/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.integration.microcontainer;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.visitor.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.spi.deployer.AbstractOptionalVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.virtual.VirtualFile;
import org.jboss.webbeans.integration.microcontainer.JBossWebBeansMetaData;
import org.jboss.webbeans.integration.microcontainer.WebBeanDiscoveryEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBeanDiscoveryDeployer
extends AbstractOptionalVFSRealDeployer<JBossWebBeansMetaData> {
    public WebBeanDiscoveryDeployer() {
        super(JBossWebBeansMetaData.class);
        this.addOutput(WebBeanDiscoveryEnvironment.class);
    }

    public void deploy(VFSDeploymentUnit unit, JBossWebBeansMetaData deployment) throws DeploymentException {
        VFSDeploymentUnit topUnit = unit.getTopLevel();
        WebBeanDiscoveryEnvironment environment = (WebBeanDiscoveryEnvironment)topUnit.getAttachment(WebBeanDiscoveryEnvironment.class);
        if (environment == null) {
            environment = new WebBeanDiscoveryEnvironment();
            topUnit.addAttachment(WebBeanDiscoveryEnvironment.class, (Object)environment);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            if (deployment != null) {
                // empty if block
            }
            Iterable<VirtualFile> classpaths = this.getClassPaths(unit);
            for (VirtualFile cp : classpaths) {
                VirtualFile wbXml = cp.getChild("META-INF/web-beans.xml");
                if (wbXml == null) continue;
                environment.addWebBeansXmlURL(wbXml.toURL());
                urls.add(cp.toURL());
            }
            VirtualFile warWbXml = unit.getFile("WEB-INF/web-beans.xml");
            if (warWbXml != null) {
                environment.addWebBeansXmlURL(warWbXml.toURL());
                VirtualFile classes = unit.getFile("WEB-INF/classes");
                if (classes != null) {
                    urls.add(classes.toURL());
                }
            }
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Cannot deploy WBD.", (Throwable)e);
        }
        if (!urls.isEmpty()) {
            Module module = (Module)unit.getAttachment(Module.class);
            if (module == null) {
                for (VFSDeploymentUnit parent = unit.getParent(); parent != null && module == null; parent = parent.getParent()) {
                    module = (Module)parent.getAttachment(Module.class);
                }
                if (module == null) {
                    throw new DeploymentException("No module in deployment unit's hierarchy: " + unit.getName());
                }
            }
            WBDiscoveryVisitor visitor = new WBDiscoveryVisitor(environment);
            module.visit((ResourceVisitor)visitor, (ResourceFilter)ClassFilter.INSTANCE, null, urls.toArray(new URL[urls.size()]));
        }
    }

    protected Iterable<VirtualFile> getClassPaths(VFSDeploymentUnit unit) throws Exception {
        List classpath = unit.getClassPath();
        if (classpath != null && !classpath.isEmpty()) {
            ArrayList<VirtualFile> matching = new ArrayList<VirtualFile>();
            VirtualFile root = unit.getRoot();
            Iterator i$ = classpath.iterator();
            while (i$.hasNext()) {
                VirtualFile cp;
                VirtualFile check;
                for (check = cp = (VirtualFile)i$.next(); check != null && !check.equals((Object)root); check = check.getParent()) {
                }
                if (check == null) continue;
                matching.add(cp);
            }
            return matching;
        }
        return Collections.emptySet();
    }

    private class WBDiscoveryVisitor
    implements ResourceVisitor {
        private WebBeanDiscoveryEnvironment wbdi;

        private WBDiscoveryVisitor(WebBeanDiscoveryEnvironment wbdi) {
            this.wbdi = wbdi;
        }

        public ResourceFilter getFilter() {
            return ClassFilter.INSTANCE;
        }

        public void visit(ResourceContext resource) {
            this.wbdi.addWebBeanClass(resource.loadClass());
        }
    }
}

