package org.jboss.webbeans.integration.microcontainer;


import java.net.MalformedURLException;
import java.net.URL;

import org.jboss.deployers.vfs.plugins.classloader.PathUrlIntegrationDeployer;
import org.jboss.util.StringPropertyReplacer;

/**
 * Web Beans RI integration deployer.
 *
 * @param <T> exact input type
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 * 
 * TODO Move into deployer
 */
public abstract class WebBeansUrlIntegrationDeployer<T> extends PathUrlIntegrationDeployer<T>
{
   protected WebBeansUrlIntegrationDeployer(Class<T> input)
   {
      super(input);
      setIntegrationURL(getURL());
      setFiles(new String[]{"META-INF/web-beans.xml", "WEB-INF/web-beans.xml"}
      );
   }

   /**
    * Get the Seam integration url.
    *
    * @return the seam jbossas integration url
    */
   protected URL getURL()
   {
      try
      {
         String url = getServerHome() + getOptionalLib() + getIntegrationJar();
         url = StringPropertyReplacer.replaceProperties(url);
         if (log.isTraceEnabled())
            log.trace("Web Beans integration url: " + url);
         return new URL(url);
      }
      catch (MalformedURLException e)
      {
         throw new IllegalArgumentException("Unexpected error: " + e);
      }
   }

   /**
    * Get server home.
    *
    * @return the jboss server home location
    */
   protected String getServerHome()
   {
      return "${jboss.server.home.url}";
   }

   /**
    * Get the optinal lib path.
    *
    * @return the integration path
    */
   protected String getOptionalLib()
   {
      return "deployers/webbeans.deployer/lib-int/";
   }

   /**
    * Get the integration jar.
    *
    * @return the integration jar
    */
   protected String getIntegrationJar()
   {
      return "webbeans-ri.jar";
   }
}
