/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import org.apache.coyote.http11.upgrade.AbstractServletOutputStream;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.WsRemoteEndpointImplBase;
import org.apache.tomcat.websocket.server.WsServerContainer;
import org.apache.tomcat.websocket.server.WsWriteTimeout;
import org.jboss.web.WebsocketsLogger;

public class WsRemoteEndpointImplServer
extends WsRemoteEndpointImplBase {
    private static final Queue<OnResultRunnable> onResultRunnables = new ConcurrentLinkedQueue<OnResultRunnable>();
    private final AbstractServletOutputStream sos;
    private final WsWriteTimeout wsWriteTimeout;
    private final ExecutorService executorService;
    private volatile SendHandler handler = null;
    private volatile ByteBuffer[] buffers = null;
    private final Object connectionWriteLock = new Object();
    private volatile long timeoutExpiry = -1L;
    private volatile boolean close;

    public WsRemoteEndpointImplServer(AbstractServletOutputStream sos, WsServerContainer serverContainer) {
        this.sos = sos;
        this.wsWriteTimeout = serverContainer.getTimeout();
        this.executorService = serverContainer.getExecutorService();
    }

    @Override
    protected final boolean isMasked() {
        return false;
    }

    @Override
    protected void doWrite(SendHandler handler, ByteBuffer ... buffers) {
        this.handler = handler;
        this.buffers = buffers;
        this.onWritePossible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWritePossible(boolean useDispatch) {
        Object object = this.connectionWriteLock;
        synchronized (object) {
            long timeout;
            if (this.buffers == null) {
                return;
            }
            boolean complete = true;
            try {
                while (this.sos.isReady()) {
                    complete = true;
                    ByteBuffer[] byteBufferArray = this.buffers;
                    int n = byteBufferArray.length;
                    for (int i = 0; i < n; ++i) {
                        ByteBuffer buffer;
                        ByteBuffer byteBuffer = buffer = byteBufferArray[i];
                        synchronized (byteBuffer) {
                            if (buffer.hasRemaining()) {
                                complete = false;
                                this.sos.write(buffer.array(), buffer.arrayOffset(), buffer.limit());
                                buffer.position(buffer.limit());
                                break;
                            }
                            continue;
                        }
                    }
                    if (!complete) continue;
                    this.sos.flush();
                    complete = this.sos.isReady();
                    if (complete) {
                        this.wsWriteTimeout.unregister(this);
                        this.clearHandler(null, useDispatch);
                        if (this.close) {
                            this.close();
                        }
                    }
                    break;
                }
            }
            catch (IOException ioe) {
                this.wsWriteTimeout.unregister(this);
                this.clearHandler(ioe, useDispatch);
                this.close();
            }
            if (!complete && (timeout = this.getSendTimeout()) > 0L) {
                this.timeoutExpiry = timeout + System.currentTimeMillis();
                this.wsWriteTimeout.register(this);
            }
        }
    }

    @Override
    protected void doClose() {
        if (this.handler != null) {
            this.clearHandler(new EOFException(), true);
        }
        try {
            this.sos.close();
        }
        catch (IOException e) {
            WebsocketsLogger.ROOT_LOGGER.closeFailed(e);
        }
        this.wsWriteTimeout.unregister(this);
    }

    protected long getTimeoutExpiry() {
        return this.timeoutExpiry;
    }

    protected void onTimeout(boolean useDispatch) {
        if (this.handler != null) {
            this.clearHandler(new SocketTimeoutException(), useDispatch);
        }
        this.close();
    }

    @Override
    protected void setTransformation(Transformation transformation) {
        super.setTransformation(transformation);
    }

    private void clearHandler(Throwable t, boolean useDispatch) {
        SendHandler sh = this.handler;
        this.handler = null;
        this.buffers = null;
        if (sh != null) {
            if (useDispatch) {
                OnResultRunnable r = onResultRunnables.poll();
                if (r == null) {
                    r = new OnResultRunnable(onResultRunnables);
                }
                r.init(sh, t);
                if (this.executorService == null || this.executorService.isShutdown()) {
                    r.run();
                } else {
                    this.executorService.execute(r);
                }
            } else if (t == null) {
                sh.onResult(new SendResult());
            } else {
                sh.onResult(new SendResult(t));
            }
        }
    }

    private static class OnResultRunnable
    implements Runnable {
        private final Queue<OnResultRunnable> queue;
        private volatile SendHandler sh;
        private volatile Throwable t;

        private OnResultRunnable(Queue<OnResultRunnable> queue) {
            this.queue = queue;
        }

        private void init(SendHandler sh, Throwable t) {
            this.sh = sh;
            this.t = t;
        }

        @Override
        public void run() {
            if (this.t == null) {
                this.sh.onResult(new SendResult());
            } else {
                this.sh.onResult(new SendResult(this.t));
            }
            this.t = null;
            this.sh = null;
            this.queue.add(this);
        }
    }
}

