/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.apache.catalina.ThreadBindingListener;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.websocket.InstanceHandle;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerWholeBase;
import org.apache.tomcat.websocket.pojo.PojoMethodMapping;
import org.jboss.web.WebsocketsLogger;

public abstract class PojoEndpointBase
extends Endpoint {
    private Object pojo;
    private InstanceHandle instanceHandle;
    private Map<String, String> pathParameters;
    private PojoMethodMapping methodMapping;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doOnOpen(Session session, EndpointConfig config) {
        PojoMethodMapping methodMapping = this.getMethodMapping();
        Object pojo = this.getPojo();
        Map<String, String> pathParameters = this.getPathParameters();
        for (MessageHandler mh : methodMapping.getMessageHandlers(pojo, pathParameters, session, config)) {
            session.addMessageHandler(mh);
        }
        if (methodMapping.getOnOpen() != null) {
            ThreadBindingListener tbl = ((WsSession)session).getThreadBindingListener();
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((WsSession)session).getClassLoader());
                tbl.bind();
                methodMapping.getOnOpen().invoke(pojo, methodMapping.getOnOpenArgs(pathParameters, session, config));
            }
            catch (IllegalAccessException e) {
                WebsocketsLogger.ROOT_LOGGER.onOpenFailed(pojo.getClass().getName(), e);
                this.handleOnOpenError(session, e);
                return;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                this.handleOnOpenError(session, cause);
                return;
            }
            catch (Throwable t) {
                this.handleOnOpenError(session, t);
                return;
            }
            finally {
                try {
                    tbl.unbind();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
        }
    }

    private void handleOnOpenError(Session session, Throwable t) {
        ExceptionUtils.handleThrowable(t);
        this.onError(session, t);
        try {
            session.close();
        }
        catch (IOException ioe) {
            WebsocketsLogger.ROOT_LOGGER.closeSessionFailed(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onClose(Session session, CloseReason closeReason) {
        try {
            if (this.methodMapping.getOnClose() != null) {
                ThreadBindingListener tbl = ((WsSession)session).getThreadBindingListener();
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(((WsSession)session).getClassLoader());
                    tbl.bind();
                    this.methodMapping.getOnClose().invoke(this.pojo, this.methodMapping.getOnCloseArgs(this.pathParameters, session, closeReason));
                }
                catch (Throwable t) {
                    WebsocketsLogger.ROOT_LOGGER.onCloseFailed(this.pojo.getClass().getName(), t);
                    this.handleOnCloseError(session, t);
                }
                finally {
                    try {
                        tbl.unbind();
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(old);
                    }
                }
            }
            Set<MessageHandler> messageHandlers = session.getMessageHandlers();
            for (MessageHandler messageHandler : messageHandlers) {
                if (!(messageHandler instanceof PojoMessageHandlerWholeBase)) continue;
                ((PojoMessageHandlerWholeBase)messageHandler).onClose();
            }
        }
        finally {
            if (this.instanceHandle != null) {
                this.instanceHandle.release();
                this.instanceHandle = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOnCloseError(Session session, Throwable t) {
        try {
            ExceptionUtils.handleThrowable(t);
            this.onError(session, t);
            try {
                session.close();
            }
            catch (IOException ioe) {
                WebsocketsLogger.ROOT_LOGGER.closeSessionFailed(ioe);
            }
        }
        finally {
            if (this.instanceHandle != null) {
                this.instanceHandle.release();
                this.instanceHandle = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onError(Session session, Throwable throwable) {
        if (this.methodMapping.getOnError() == null) {
            WebsocketsLogger.ROOT_LOGGER.noOnError(this.pojo.getClass().getName(), throwable);
        } else {
            ThreadBindingListener tbl = ((WsSession)session).getThreadBindingListener();
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((WsSession)session).getClassLoader());
                tbl.bind();
                this.methodMapping.getOnError().invoke(this.pojo, this.methodMapping.getOnErrorArgs(this.pathParameters, session, throwable));
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                WebsocketsLogger.ROOT_LOGGER.onErrorFailed(this.pojo.getClass().getName(), t);
            }
            finally {
                try {
                    tbl.unbind();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
        }
    }

    protected Object getPojo() {
        return this.pojo;
    }

    protected void setPojo(Object pojo) {
        this.pojo = pojo;
    }

    public InstanceHandle getInstanceHandle() {
        return this.instanceHandle;
    }

    public void setInstanceHandle(InstanceHandle instanceHandle) {
        this.instanceHandle = instanceHandle;
    }

    protected Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    protected void setPathParameters(Map<String, String> pathParameters) {
        this.pathParameters = pathParameters;
    }

    protected PojoMethodMapping getMethodMapping() {
        return this.methodMapping;
    }

    protected void setMethodMapping(PojoMethodMapping methodMapping) {
        this.methodMapping = methodMapping;
    }
}

