/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse.openssl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tomcat.util.net.jsse.JSSELogger;
import org.apache.tomcat.util.net.jsse.openssl.Authentication;
import org.apache.tomcat.util.net.jsse.openssl.Ciphers;
import org.apache.tomcat.util.net.jsse.openssl.Encryption;
import org.apache.tomcat.util.net.jsse.openssl.EncryptionLevel;
import org.apache.tomcat.util.net.jsse.openssl.KeyExchange;
import org.apache.tomcat.util.net.jsse.openssl.MessageDigest;
import org.apache.tomcat.util.net.jsse.openssl.Protocol;

public class OpenSSLCipherConfigurationParser {
    public static final String DEFAULT_EXPRESSION_KEY = "openssl.default.ciphers";
    private static boolean initialized = false;
    private static final String SEPARATOR = ":";
    private static final String EXCLUDE = "!";
    private static final String DELETE = "-";
    private static final String TO_END = "+";
    private static final String AND = "+";
    private static final Map<String, List<Ciphers>> aliases = new LinkedHashMap<String, List<Ciphers>>();
    private static final String eNULL = "eNULL";
    private static final String aNULL = "aNULL";
    private static final String HIGH = "HIGH";
    private static final String MEDIUM = "MEDIUM";
    private static final String LOW = "LOW";
    private static final String EXPORT = "EXPORT";
    private static final String EXPORT40 = "EXPORT40";
    private static final String EXPORT56 = "EXPORT56";
    private static final String kRSA = "kRSA";
    private static final String aRSA = "aRSA";
    private static final String RSA = "RSA";
    private static final String kEDH = "kEDH";
    private static final String kDHE = "kDHE";
    private static final String EDH = "EDH";
    private static final String DHE = "DHE";
    private static final String kDHr = "kDHr";
    private static final String kDHd = "kDHd";
    private static final String kDH = "kDH";
    private static final String kECDHr = "kECDHr";
    private static final String kECDHe = "kECDHe";
    private static final String kECDH = "kECDH";
    private static final String kEECDH = "kEECDH";
    private static final String ECDH = "ECDH";
    private static final String kECDHE = "kECDHE";
    private static final String ECDHE = "ECDHE";
    private static final String EECDHE = "EECDHE";
    private static final String AECDH = "AECDH";
    private static final String aDSS = "aDSS";
    private static final String aDH = "aDH";
    private static final String aECDH = "aECDH";
    private static final String aECDSA = "aECDSA";
    private static final String ECDSA = "ECDSA";
    private static final String kFZA = "kFZA";
    private static final String aFZA = "aFZA";
    private static final String eFZA = "eFZA";
    private static final String FZA = "FZA";
    private static final String TLSv1_2 = "TLSv1_2";
    private static final String TLSv1 = "TLSv1";
    private static final String SSLv2 = "SSLv2";
    private static final String SSLv3 = "SSLv3";
    private static final String DH = "DH";
    private static final String ADH = "ADH";
    private static final String AES128 = "AES128";
    private static final String AES256 = "AES256";
    private static final String AES = "AES";
    private static final String AESGCM = "AESGCM";
    private static final String CAMELLIA128 = "CAMELLIA128";
    private static final String CAMELLIA256 = "CAMELLIA256";
    private static final String CAMELLIA = "CAMELLIA";
    private static final String TRIPLE_DES = "3DES";
    private static final String DES = "DES";
    private static final String RC4 = "RC4";
    private static final String RC2 = "RC2";
    private static final String IDEA = "IDEA";
    private static final String SEED = "SEED";
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA1";
    private static final String SHA = "SHA";
    private static final String SHA256 = "SHA256";
    private static final String SHA384 = "SHA384";
    private static final String KRB5 = "KRB5";
    private static final String aGOST = "aGOST";
    private static final String aGOST01 = "aGOST01";
    private static final String aGOST94 = "aGOST94";
    private static final String kGOST = "kGOST";
    private static final String GOST94 = "GOST94";
    private static final String GOST89MAC = "GOST89MAC";
    private static final String PSK = "PSK";
    private static final String DEFAULT = "DEFAULT";
    private static final String COMPLEMENTOFDEFAULT = "COMPLEMENTOFDEFAULT";
    private static final String ALL = "ALL";
    private static final String COMPLEMENTOFALL = "COMPLEMENTOFALL";

    private static final void init() {
        for (Ciphers cipher : Ciphers.values()) {
            String alias = cipher.getOpenSSLAlias();
            if (aliases.containsKey(alias)) {
                aliases.get(alias).add(cipher);
            } else {
                ArrayList<Ciphers> list = new ArrayList<Ciphers>();
                list.add(cipher);
                aliases.put(alias, list);
            }
            aliases.put(cipher.name(), Collections.singletonList(cipher));
        }
        List<Ciphers> allCiphers = Arrays.asList(Ciphers.values());
        Collections.reverse(allCiphers);
        LinkedHashSet<Ciphers> all = OpenSSLCipherConfigurationParser.defaultSort(new LinkedHashSet<Ciphers>(allCiphers));
        OpenSSLCipherConfigurationParser.addListAlias(ALL, all);
        OpenSSLCipherConfigurationParser.addListAlias(HIGH, OpenSSLCipherConfigurationParser.filterByEncryptionLevel(all, Collections.singleton(EncryptionLevel.HIGH)));
        OpenSSLCipherConfigurationParser.addListAlias(MEDIUM, OpenSSLCipherConfigurationParser.filterByEncryptionLevel(all, Collections.singleton(EncryptionLevel.MEDIUM)));
        OpenSSLCipherConfigurationParser.addListAlias(LOW, OpenSSLCipherConfigurationParser.filterByEncryptionLevel(all, Collections.singleton(EncryptionLevel.LOW)));
        OpenSSLCipherConfigurationParser.addListAlias(EXPORT, OpenSSLCipherConfigurationParser.filterByEncryptionLevel(all, new HashSet<EncryptionLevel>(Arrays.asList(EncryptionLevel.EXP40, EncryptionLevel.EXP56))));
        aliases.put("EXP", aliases.get(EXPORT));
        OpenSSLCipherConfigurationParser.addListAlias(EXPORT40, OpenSSLCipherConfigurationParser.filterByEncryptionLevel(all, Collections.singleton(EncryptionLevel.EXP40)));
        OpenSSLCipherConfigurationParser.addListAlias(EXPORT56, OpenSSLCipherConfigurationParser.filterByEncryptionLevel(all, Collections.singleton(EncryptionLevel.EXP56)));
        OpenSSLCipherConfigurationParser.addListAlias(eNULL, OpenSSLCipherConfigurationParser.filterByEncryption(all, Collections.singleton(Encryption.eNULL)));
        aliases.put("NULL", aliases.get(eNULL));
        aliases.put(COMPLEMENTOFALL, aliases.get(eNULL));
        OpenSSLCipherConfigurationParser.addListAlias(aNULL, OpenSSLCipherConfigurationParser.filterByAuthentication(all, Collections.singleton(Authentication.aNULL)));
        OpenSSLCipherConfigurationParser.addListAlias(kRSA, OpenSSLCipherConfigurationParser.filterByKeyExchange(all, Collections.singleton(KeyExchange.RSA)));
        OpenSSLCipherConfigurationParser.addListAlias(aRSA, OpenSSLCipherConfigurationParser.filterByAuthentication(all, Collections.singleton(Authentication.RSA)));
        OpenSSLCipherConfigurationParser.addListAlias(RSA, OpenSSLCipherConfigurationParser.filter(all, null, Collections.singleton(KeyExchange.RSA), Collections.singleton(Authentication.RSA), null, null, null));
        OpenSSLCipherConfigurationParser.addListAlias(kEDH, OpenSSLCipherConfigurationParser.filterByKeyExchange(all, Collections.singleton(KeyExchange.EDH)));
        OpenSSLCipherConfigurationParser.addListAlias(kDHE, OpenSSLCipherConfigurationParser.filterByKeyExchange(all, Collections.singleton(KeyExchange.EDH)));
        Set<Ciphers> edh = OpenSSLCipherConfigurationParser.filterByKeyExchange(all, Collections.singleton(KeyExchange.EDH));
        edh.removeAll(OpenSSLCipherConfigurationParser.filterByAuthentication(all, Collections.singleton(Authentication.DH)));
        OpenSSLCipherConfigurationParser.addListAlias(EDH, edh);
        OpenSSLCipherConfigurationParser.addListAlias(DHE, edh);
        OpenSSLCipherConfigurationParser.addListAlias(kDHr, OpenSSLCipherConfigurationParser.filterByKeyExchange(all, Collections.singleton(KeyExchange.DHr)));
        OpenSSLCipherConfigurationParser.addListAlias(kDHd, OpenSSLCipherConfigurationParser.filterByKeyExchange(all, Collections.singleton(KeyExchange.DHd)));
        OpenSSLCipherConfigurationParser.addListAlias(kDH, OpenSSLCipherConfigurationParser.filterByKeyExchange(all, new HashSet<KeyExchange>(Arrays.asList(KeyExchange.DHr, KeyExchange.DHd))));
        OpenSSLCipherConfigurationParser.addListAlias(kECDHr, OpenSSLCipherConfigurationParser.filterByKeyExchange(all, Collections.singleton(KeyExchange.ECDHr)));
        OpenSSLCipherConfigurationParser.addListAlias(kECDHe, OpenSSLCipherConfigurationParser.filterByKeyExchange(all, Collections.singleton(KeyExchange.ECDHe)));
        OpenSSLCipherConfigurationParser.addListAlias(kECDH, OpenSSLCipherConfigurationParser.filterByKeyExchange(all, new HashSet<KeyExchange>(Arrays.asList(KeyExchange.ECDHe, KeyExchange.ECDHr))));
        aliases.put(ECDH, aliases.get(kECDH));
        OpenSSLCipherConfigurationParser.addListAlias(kECDHE, OpenSSLCipherConfigurationParser.filterByKeyExchange(all, Collections.singleton(KeyExchange.ECDHe)));
        aliases.put(ECDHE, aliases.get(kECDHE));
        OpenSSLCipherConfigurationParser.addListAlias(kEECDH, OpenSSLCipherConfigurationParser.filterByKeyExchange(all, Collections.singleton(KeyExchange.EECDH)));
        aliases.put(EECDHE, aliases.get(kEECDH));
        OpenSSLCipherConfigurationParser.addListAlias(aDSS, OpenSSLCipherConfigurationParser.filterByAuthentication(all, Collections.singleton(Authentication.DSS)));
        aliases.put("DSS", aliases.get(aDSS));
        OpenSSLCipherConfigurationParser.addListAlias(aDH, OpenSSLCipherConfigurationParser.filterByAuthentication(all, Collections.singleton(Authentication.DH)));
        Set<Ciphers> aecdh = OpenSSLCipherConfigurationParser.filterByKeyExchange(all, new HashSet<KeyExchange>(Arrays.asList(KeyExchange.ECDHe, KeyExchange.ECDHr)));
        aecdh.removeAll(OpenSSLCipherConfigurationParser.filterByAuthentication(all, Collections.singleton(Authentication.aNULL)));
        OpenSSLCipherConfigurationParser.addListAlias(AECDH, aecdh);
        OpenSSLCipherConfigurationParser.addListAlias(aECDH, OpenSSLCipherConfigurationParser.filterByAuthentication(all, Collections.singleton(Authentication.ECDH)));
        OpenSSLCipherConfigurationParser.addListAlias(ECDSA, OpenSSLCipherConfigurationParser.filterByAuthentication(all, Collections.singleton(Authentication.ECDSA)));
        aliases.put(aECDSA, aliases.get(ECDSA));
        OpenSSLCipherConfigurationParser.addListAlias(kFZA, OpenSSLCipherConfigurationParser.filterByKeyExchange(all, Collections.singleton(KeyExchange.FZA)));
        OpenSSLCipherConfigurationParser.addListAlias(aFZA, OpenSSLCipherConfigurationParser.filterByAuthentication(all, Collections.singleton(Authentication.FZA)));
        OpenSSLCipherConfigurationParser.addListAlias(eFZA, OpenSSLCipherConfigurationParser.filterByEncryption(all, Collections.singleton(Encryption.FZA)));
        OpenSSLCipherConfigurationParser.addListAlias(FZA, OpenSSLCipherConfigurationParser.filter(all, null, Collections.singleton(KeyExchange.FZA), Collections.singleton(Authentication.FZA), Collections.singleton(Encryption.FZA), null, null));
        OpenSSLCipherConfigurationParser.addListAlias(TLSv1_2, OpenSSLCipherConfigurationParser.filterByProtocol(all, Collections.singleton(Protocol.TLSv1_2)));
        OpenSSLCipherConfigurationParser.addListAlias("TLSv1.1", OpenSSLCipherConfigurationParser.filterByProtocol(all, Collections.singleton(Protocol.SSLv3)));
        OpenSSLCipherConfigurationParser.addListAlias(TLSv1, OpenSSLCipherConfigurationParser.filterByProtocol(all, Collections.singleton(Protocol.TLSv1)));
        OpenSSLCipherConfigurationParser.addListAlias(SSLv3, OpenSSLCipherConfigurationParser.filterByProtocol(all, Collections.singleton(Protocol.SSLv3)));
        OpenSSLCipherConfigurationParser.addListAlias(SSLv2, OpenSSLCipherConfigurationParser.filterByProtocol(all, Collections.singleton(Protocol.SSLv2)));
        OpenSSLCipherConfigurationParser.addListAlias(DH, OpenSSLCipherConfigurationParser.filterByKeyExchange(all, new HashSet<KeyExchange>(Arrays.asList(KeyExchange.DHr, KeyExchange.DHd, KeyExchange.EDH))));
        Set<Ciphers> adh = OpenSSLCipherConfigurationParser.filterByKeyExchange(all, Collections.singleton(KeyExchange.EDH));
        adh.retainAll(OpenSSLCipherConfigurationParser.filterByAuthentication(all, Collections.singleton(Authentication.aNULL)));
        OpenSSLCipherConfigurationParser.addListAlias(ADH, adh);
        OpenSSLCipherConfigurationParser.addListAlias(AES128, OpenSSLCipherConfigurationParser.filterByEncryption(all, new HashSet<Encryption>(Arrays.asList(Encryption.AES128, Encryption.AES128GCM))));
        OpenSSLCipherConfigurationParser.addListAlias(AES256, OpenSSLCipherConfigurationParser.filterByEncryption(all, new HashSet<Encryption>(Arrays.asList(Encryption.AES256, Encryption.AES256GCM))));
        OpenSSLCipherConfigurationParser.addListAlias(AES, OpenSSLCipherConfigurationParser.filterByEncryption(all, new HashSet<Encryption>(Arrays.asList(Encryption.AES128, Encryption.AES128GCM, Encryption.AES256, Encryption.AES256GCM))));
        OpenSSLCipherConfigurationParser.addListAlias(AESGCM, OpenSSLCipherConfigurationParser.filterByEncryption(all, new HashSet<Encryption>(Arrays.asList(Encryption.AES128GCM, Encryption.AES256GCM))));
        OpenSSLCipherConfigurationParser.addListAlias(CAMELLIA, OpenSSLCipherConfigurationParser.filterByEncryption(all, new HashSet<Encryption>(Arrays.asList(Encryption.CAMELLIA128, Encryption.CAMELLIA256))));
        OpenSSLCipherConfigurationParser.addListAlias(CAMELLIA128, OpenSSLCipherConfigurationParser.filterByEncryption(all, Collections.singleton(Encryption.CAMELLIA128)));
        OpenSSLCipherConfigurationParser.addListAlias(CAMELLIA256, OpenSSLCipherConfigurationParser.filterByEncryption(all, Collections.singleton(Encryption.CAMELLIA256)));
        OpenSSLCipherConfigurationParser.addListAlias(TRIPLE_DES, OpenSSLCipherConfigurationParser.filterByEncryption(all, Collections.singleton(Encryption.TRIPLE_DES)));
        OpenSSLCipherConfigurationParser.addListAlias(DES, OpenSSLCipherConfigurationParser.filterByEncryption(all, Collections.singleton(Encryption.DES)));
        OpenSSLCipherConfigurationParser.addListAlias(RC4, OpenSSLCipherConfigurationParser.filterByEncryption(all, Collections.singleton(Encryption.RC4)));
        OpenSSLCipherConfigurationParser.addListAlias(RC2, OpenSSLCipherConfigurationParser.filterByEncryption(all, Collections.singleton(Encryption.RC2)));
        OpenSSLCipherConfigurationParser.addListAlias(IDEA, OpenSSLCipherConfigurationParser.filterByEncryption(all, Collections.singleton(Encryption.IDEA)));
        OpenSSLCipherConfigurationParser.addListAlias(SEED, OpenSSLCipherConfigurationParser.filterByEncryption(all, Collections.singleton(Encryption.SEED)));
        OpenSSLCipherConfigurationParser.addListAlias(MD5, OpenSSLCipherConfigurationParser.filterByMessageDigest(all, Collections.singleton(MessageDigest.MD5)));
        OpenSSLCipherConfigurationParser.addListAlias(SHA1, OpenSSLCipherConfigurationParser.filterByMessageDigest(all, Collections.singleton(MessageDigest.SHA1)));
        aliases.put(SHA, aliases.get(SHA1));
        OpenSSLCipherConfigurationParser.addListAlias(SHA256, OpenSSLCipherConfigurationParser.filterByMessageDigest(all, Collections.singleton(MessageDigest.SHA256)));
        OpenSSLCipherConfigurationParser.addListAlias(SHA384, OpenSSLCipherConfigurationParser.filterByMessageDigest(all, Collections.singleton(MessageDigest.SHA384)));
        OpenSSLCipherConfigurationParser.addListAlias(aGOST, OpenSSLCipherConfigurationParser.filterByAuthentication(all, new HashSet<Authentication>(Arrays.asList(Authentication.GOST01, Authentication.GOST94))));
        OpenSSLCipherConfigurationParser.addListAlias(aGOST01, OpenSSLCipherConfigurationParser.filterByAuthentication(all, Collections.singleton(Authentication.GOST01)));
        OpenSSLCipherConfigurationParser.addListAlias(aGOST94, OpenSSLCipherConfigurationParser.filterByAuthentication(all, Collections.singleton(Authentication.GOST94)));
        OpenSSLCipherConfigurationParser.addListAlias(kGOST, OpenSSLCipherConfigurationParser.filterByKeyExchange(all, Collections.singleton(KeyExchange.GOST)));
        OpenSSLCipherConfigurationParser.addListAlias(GOST94, OpenSSLCipherConfigurationParser.filterByMessageDigest(all, Collections.singleton(MessageDigest.GOST94)));
        OpenSSLCipherConfigurationParser.addListAlias(GOST89MAC, OpenSSLCipherConfigurationParser.filterByMessageDigest(all, Collections.singleton(MessageDigest.GOST89MAC)));
        OpenSSLCipherConfigurationParser.addListAlias(PSK, OpenSSLCipherConfigurationParser.filter(all, null, Collections.singleton(KeyExchange.PSK), Collections.singleton(Authentication.PSK), null, null, null));
        OpenSSLCipherConfigurationParser.addListAlias(KRB5, OpenSSLCipherConfigurationParser.filter(all, null, Collections.singleton(KeyExchange.KRB5), Collections.singleton(Authentication.KRB5), null, null, null));
        initialized = true;
        String defaultExpression = System.getProperty(DEFAULT_EXPRESSION_KEY, "ALL:!eNULL:!aNULL");
        OpenSSLCipherConfigurationParser.addListAlias(DEFAULT, OpenSSLCipherConfigurationParser.parse(defaultExpression));
        LinkedHashSet<Ciphers> complementOfDefault = new LinkedHashSet<Ciphers>(all);
        complementOfDefault.removeAll((Collection)aliases.get(DEFAULT));
        OpenSSLCipherConfigurationParser.addListAlias(COMPLEMENTOFDEFAULT, complementOfDefault);
    }

    static void addListAlias(String alias, Set<Ciphers> ciphers) {
        aliases.put(alias, new ArrayList<Ciphers>(ciphers));
    }

    static void moveToEnd(LinkedHashSet<Ciphers> ciphers, String alias) {
        OpenSSLCipherConfigurationParser.moveToEnd(ciphers, (Collection<Ciphers>)aliases.get(alias));
    }

    static void moveToEnd(LinkedHashSet<Ciphers> ciphers, Collection<Ciphers> toBeMovedCiphers) {
        ArrayList<Ciphers> movedCiphers = new ArrayList<Ciphers>(toBeMovedCiphers);
        movedCiphers.retainAll(ciphers);
        ciphers.removeAll(movedCiphers);
        ciphers.addAll(movedCiphers);
    }

    static void add(LinkedHashSet<Ciphers> ciphers, String alias) {
        ciphers.addAll((Collection<Ciphers>)aliases.get(alias));
    }

    static void remove(LinkedHashSet<Ciphers> ciphers, String alias) {
        ciphers.removeAll((Collection)aliases.get(alias));
    }

    static LinkedHashSet<Ciphers> strengthSort(LinkedHashSet<Ciphers> ciphers) {
        HashSet<Integer> keySizes = new HashSet<Integer>();
        for (Ciphers cipher : ciphers) {
            keySizes.add(cipher.getStrength_bits());
        }
        ArrayList strength_bits = new ArrayList(keySizes);
        Collections.sort(strength_bits);
        Collections.reverse(strength_bits);
        LinkedHashSet<Ciphers> result = new LinkedHashSet<Ciphers>(ciphers);
        Iterator i$ = strength_bits.iterator();
        while (i$.hasNext()) {
            int strength = (Integer)i$.next();
            OpenSSLCipherConfigurationParser.moveToEnd(result, OpenSSLCipherConfigurationParser.filterByStrengthBits(ciphers, strength));
        }
        return result;
    }

    static LinkedHashSet<Ciphers> defaultSort(LinkedHashSet<Ciphers> ciphers) {
        LinkedHashSet<Ciphers> result = new LinkedHashSet<Ciphers>(ciphers.size());
        result.addAll(OpenSSLCipherConfigurationParser.filterByKeyExchange(ciphers, Collections.singleton(KeyExchange.EECDH)));
        result.addAll(OpenSSLCipherConfigurationParser.filterByEncryption(ciphers, new HashSet<Encryption>(Arrays.asList(Encryption.AES128, Encryption.AES128GCM, Encryption.AES256, Encryption.AES256GCM))));
        result.addAll(ciphers);
        OpenSSLCipherConfigurationParser.moveToEnd(result, OpenSSLCipherConfigurationParser.filterByMessageDigest(result, Collections.singleton(MessageDigest.MD5)));
        OpenSSLCipherConfigurationParser.moveToEnd(result, OpenSSLCipherConfigurationParser.filterByAuthentication(result, Collections.singleton(Authentication.aNULL)));
        OpenSSLCipherConfigurationParser.moveToEnd(result, OpenSSLCipherConfigurationParser.filterByAuthentication(result, Collections.singleton(Authentication.ECDH)));
        OpenSSLCipherConfigurationParser.moveToEnd(result, OpenSSLCipherConfigurationParser.filterByKeyExchange(result, Collections.singleton(KeyExchange.RSA)));
        OpenSSLCipherConfigurationParser.moveToEnd(result, OpenSSLCipherConfigurationParser.filterByKeyExchange(result, Collections.singleton(KeyExchange.PSK)));
        OpenSSLCipherConfigurationParser.moveToEnd(result, OpenSSLCipherConfigurationParser.filterByKeyExchange(result, Collections.singleton(KeyExchange.KRB5)));
        OpenSSLCipherConfigurationParser.moveToEnd(result, OpenSSLCipherConfigurationParser.filterByEncryption(result, Collections.singleton(Encryption.RC4)));
        return OpenSSLCipherConfigurationParser.strengthSort(result);
    }

    static Set<Ciphers> filterByStrengthBits(Set<Ciphers> ciphers, int strength_bits) {
        LinkedHashSet<Ciphers> result = new LinkedHashSet<Ciphers>(ciphers.size());
        for (Ciphers cipher : ciphers) {
            if (cipher.getStrength_bits() != strength_bits) continue;
            result.add(cipher);
        }
        return result;
    }

    static Set<Ciphers> filterByProtocol(Set<Ciphers> ciphers, Set<Protocol> protocol) {
        return OpenSSLCipherConfigurationParser.filter(ciphers, protocol, null, null, null, null, null);
    }

    static Set<Ciphers> filterByKeyExchange(Set<Ciphers> ciphers, Set<KeyExchange> kx) {
        return OpenSSLCipherConfigurationParser.filter(ciphers, null, kx, null, null, null, null);
    }

    static Set<Ciphers> filterByAuthentication(Set<Ciphers> ciphers, Set<Authentication> au) {
        return OpenSSLCipherConfigurationParser.filter(ciphers, null, null, au, null, null, null);
    }

    static Set<Ciphers> filterByEncryption(Set<Ciphers> ciphers, Set<Encryption> enc) {
        return OpenSSLCipherConfigurationParser.filter(ciphers, null, null, null, enc, null, null);
    }

    static Set<Ciphers> filterByEncryptionLevel(Set<Ciphers> ciphers, Set<EncryptionLevel> level) {
        return OpenSSLCipherConfigurationParser.filter(ciphers, null, null, null, null, level, null);
    }

    static Set<Ciphers> filterByMessageDigest(Set<Ciphers> ciphers, Set<MessageDigest> mac) {
        return OpenSSLCipherConfigurationParser.filter(ciphers, null, null, null, null, null, mac);
    }

    static Set<Ciphers> filter(Set<Ciphers> ciphers, Set<Protocol> protocol, Set<KeyExchange> kx, Set<Authentication> au, Set<Encryption> enc, Set<EncryptionLevel> level, Set<MessageDigest> mac) {
        LinkedHashSet<Ciphers> result = new LinkedHashSet<Ciphers>(ciphers.size());
        for (Ciphers cipher : ciphers) {
            if (protocol != null && protocol.contains((Object)cipher.getProtocol())) {
                result.add(cipher);
            }
            if (kx != null && kx.contains((Object)cipher.getKx())) {
                result.add(cipher);
            }
            if (au != null && au.contains((Object)cipher.getAu())) {
                result.add(cipher);
            }
            if (enc != null && enc.contains((Object)cipher.getEnc())) {
                result.add(cipher);
            }
            if (level != null && level.contains((Object)cipher.getLevel())) {
                result.add(cipher);
            }
            if (mac == null || !mac.contains((Object)cipher.getMac())) continue;
            result.add(cipher);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LinkedHashSet<Ciphers> parse(String expression) {
        Class<OpenSSLCipherConfigurationParser> clazz = OpenSSLCipherConfigurationParser.class;
        synchronized (OpenSSLCipherConfigurationParser.class) {
            if (!initialized) {
                OpenSSLCipherConfigurationParser.init();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            String[] elements = expression.split(SEPARATOR);
            LinkedHashSet<Ciphers> ciphers = new LinkedHashSet<Ciphers>();
            HashSet removedCiphers = new HashSet();
            for (String element : elements) {
                String[] intersections;
                String alias;
                if (element.startsWith(DELETE)) {
                    alias = element.substring(1);
                    if (!aliases.containsKey(alias)) continue;
                    OpenSSLCipherConfigurationParser.remove(ciphers, alias);
                    continue;
                }
                if (element.startsWith(EXCLUDE)) {
                    alias = element.substring(1);
                    if (aliases.containsKey(alias)) {
                        removedCiphers.addAll(aliases.get(alias));
                        continue;
                    }
                    JSSELogger.ROOT_LOGGER.warnUnknowElement(alias);
                    continue;
                }
                if (element.startsWith("+")) {
                    alias = element.substring(1);
                    if (!aliases.containsKey(alias)) continue;
                    OpenSSLCipherConfigurationParser.moveToEnd(ciphers, alias);
                    continue;
                }
                if ("@STRENGTH".equals(element)) {
                    OpenSSLCipherConfigurationParser.strengthSort(ciphers);
                    break;
                }
                if (aliases.containsKey(element)) {
                    OpenSSLCipherConfigurationParser.add(ciphers, element);
                    continue;
                }
                if (!element.contains("+") || (intersections = element.split("\\+")).length <= 0) continue;
                ArrayList result = new ArrayList(aliases.get(intersections[0]));
                for (int i = 1; i < intersections.length; ++i) {
                    if (!aliases.containsKey(intersections[i])) continue;
                    result.retainAll((Collection)aliases.get(intersections[i]));
                }
                ciphers.addAll(result);
            }
            ciphers.removeAll(removedCiphers);
            return OpenSSLCipherConfigurationParser.defaultSort(ciphers);
        }
    }

    static List<String> convertForJSSE(Collection<Ciphers> ciphers) {
        ArrayList<String> result = new ArrayList<String>(ciphers.size());
        for (Ciphers cipher : ciphers) {
            result.add(cipher.name());
        }
        JSSELogger.ROOT_LOGGER.logEnabledCiphers(OpenSSLCipherConfigurationParser.displayResult(ciphers, true, ","));
        return result;
    }

    public static List<String> parseExpression(String expression) {
        return OpenSSLCipherConfigurationParser.convertForJSSE(OpenSSLCipherConfigurationParser.parse(expression));
    }

    static String displayResult(Collection<Ciphers> ciphers, boolean useJSSEFormat, String separator) {
        if (ciphers.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(ciphers.size() * 16);
        for (Ciphers cipher : ciphers) {
            if (useJSSEFormat) {
                builder.append(cipher.name());
            } else {
                builder.append(cipher.getOpenSSLAlias());
            }
            builder.append(separator);
        }
        return builder.toString().substring(0, builder.length() - 1);
    }
}

