/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import org.jboss.logging.Cause;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;

@MessageBundle(projectCode="JBWEB")
public interface CatalinaMessages {
    public static final CatalinaMessages MESSAGES = (CatalinaMessages)Messages.getBundle(CatalinaMessages.class);

    @Message(id=1, value="Configuration error:  Must be attached to a Context")
    public IllegalArgumentException authenticatorNeedsContext();

    @Message(id=2, value="Security Interceptor has already been started")
    public String authenticatorAlreadyStarted();

    @Message(id=3, value="Security Interceptor has not yet been started")
    public String authenticatorNotStarted();

    @Message(id=4, value="The request body was too large to be cached during the authentication process")
    public String requestBodyTooLarge();

    @Message(id=5, value="The time allowed for the login process has been exceeded. If you wish to continue you must either click back twice and re-click the link you requested or close and re-open your browser")
    public String sessionTimeoutDuringAuthentication();

    @Message(id=6, value="Invalid direct reference to form login page")
    public String invalidFormLoginDirectReference();

    @Message(id=7, value="Unexpected error forwarding to error page")
    public String errorForwardingToFormError();

    @Message(id=8, value="Unexpected error forwarding to login page")
    public String errorForwardingToFormLogin();

    @Message(id=9, value="No client certificate chain in this request")
    public String missingRequestCertificate();

    @Message(id=10, value="Cannot authenticate with the provided credentials")
    public String certificateAuthenticationFailure();

    @Message(id=11, value="Valve has already been started")
    public String valveAlreadyStarted();

    @Message(id=12, value="Valve has not yet been started")
    public String valveNotStarted();

    @Message(id=13, value="Username [%s] NOT successfully authenticated")
    public String userNotAuthenticated(String var1);

    @Message(id=14, value="Username [%s] successfully authenticated")
    public String userAuthenticated(String var1);

    @Message(id=15, value="Access to the requested resource has been denied")
    public String forbiddenAccess();

    @Message(id=16, value="User [%s] does not have role [%s]")
    public String userDoesNotHaveRole(String var1, String var2);

    @Message(id=17, value="User [%s] has role [%s]")
    public String userHasRole(String var1, String var2);

    @Message(id=18, value="Realm has already been started")
    public String realmAlreadyStarted();

    @Message(id=19, value="Realm has not yet been started")
    public String realmNotStarted();

    @Message(id=20, value="Invalid message digest algorithm %s specified")
    public String invalidMessageDigest(String var1);

    @Message(id=21, value="Illegal digest encoding %s")
    public IllegalArgumentException illegalDigestEncoding(String var1, @Cause UnsupportedEncodingException var2);

    @Message(id=22, value="Missing MD5 digest")
    public IllegalArgumentException noMD5Digest(@Cause NoSuchAlgorithmException var1);

    @Message(id=23, value="Protocol handler initialization failed")
    public String protocolHandlerInitFailed(@Cause Throwable var1);

    @Message(id=24, value="Protocol handler start failed")
    public String protocolHandlerStartFailed(@Cause Throwable var1);

    @Message(id=25, value="Protocol handler destroy failed")
    public String protocolHandlerDestroyFailed(@Cause Throwable var1);

    @Message(id=26, value="Failed to instatiate protocol handler")
    public IllegalArgumentException protocolHandlerInstantiationFailed(@Cause Throwable var1);

    @Message(id=27, value="getWriter() has already been called for this response")
    public IllegalStateException writerAlreadyUsed();

    @Message(id=28, value="getOutputStream() has already been called for this response")
    public IllegalStateException outputStreamAlreadyUsed();

    @Message(id=29, value="Cannot reset buffer after response has been committed")
    public IllegalStateException cannotResetBuffer();

    @Message(id=30, value="Cannot change buffer size after data has been written")
    public IllegalStateException cannotChangeBufferSize();

    @Message(id=31, value="Cannot call sendError() after the response has been committed")
    public IllegalStateException cannotSendError();

    @Message(id=32, value="Cannot call sendRedirect() after the response has been committed")
    public IllegalStateException cannotSendRedirect();

    @Message(id=33, value="Cannot call sendUpgrade() after the response has been committed")
    public IllegalStateException cannotSendUpgrade();

    @Message(id=34, value="Cannot upgrade from HTTP/1.1 without IO events")
    public IllegalStateException cannotUpgradeWithoutEvents();

    @Message(id=35, value="Cannot upgrade from HTTP/1.1 is not using an HttpEventServlet")
    public IllegalStateException cannotUpgradeWithoutEventServlet();

    @Message(id=36, value="Cannot call sendFile() after the response has been committed")
    public IllegalStateException cannotSendFile();

    @Message(id=37, value="Sendfile is disabled")
    public IllegalStateException noSendFile();

    @Message(id=38, value="Invalid path for sendfile %s")
    public IllegalStateException invalidSendFilePath(String var1);

    @Message(id=39, value="getReader() has already been called for this request")
    public IllegalStateException readerAlreadyUsed();

    @Message(id=40, value="getInputStream() has already been called for this request")
    public IllegalStateException inputStreamAlreadyUsed();

    @Message(id=41, value="Exception thrown by attributes event listener")
    public String attributesEventListenerException();

    @Message(id=42, value="Cannot call setAttribute with a null name")
    public IllegalStateException attributeNameNotSpecified();

    @Message(id=43, value="Cannot create a session after the response has been committed")
    public IllegalStateException cannotCreateSession();

    @Message(id=44, value="Parameters were not parsed because the size of the posted data was too big. Use the maxPostSize attribute of the connector to resolve this if the application should accept large POSTs.")
    public IllegalStateException postDataTooLarge();

    @Message(id=45, value="The request is not multipart content")
    public String notMultipart();

    @Message(id=46, value="Exception thrown whilst processing multipart")
    public IllegalStateException multipartProcessingFailed(@Cause Throwable var1);

    @Message(id=47, value="Exception thrown whilst processing multipart")
    public IOException multipartIoProcessingFailed(@Cause Throwable var1);

    @Message(id=48, value="The servlet or filters that are being used by this request do not support async operation")
    public IllegalStateException noAsync();

    @Message(id=49, value="Response has been closed already")
    public IllegalStateException asyncClose();

    @Message(id=50, value="Cannot start async")
    public IllegalStateException cannotStartAsync();

    @Message(id=51, value="Error invoking onStartAsync on listener of class %s")
    public IllegalStateException errorStartingAsync(String var1, @Cause Throwable var2);

    @Message(id=52, value="No authenticator available for programmatic login")
    public String noAuthenticator();

    @Message(id=53, value="Failed to authenticate a principal")
    public String authenticationFailure();

    @Message(id=54, value="Exception logging out user")
    public String logoutFailure();

    @Message(id=55, value="Could not determine or access context for server absolute URI %s")
    public IllegalStateException cannotFindDispatchContext(String var1);

    @Message(id=56, value="Failed to instantiate class %s")
    public String listenerCreationFailed(String var1);

    @Message(id=57, value="The request object has been recycled and is no longer associated with this facade")
    public IllegalStateException nullRequestFacade();

    @Message(id=58, value="The response object has been recycled and is no longer associated with this facade")
    public IllegalStateException nullResponseFacade();

    @Message(id=59, value="Stream closed")
    public IOException streamClosed();

    @Message(id=64, value="Error report")
    public String errorReport();

    @Message(id=65, value="HTTP Status %s - %s")
    public String statusHeader(int var1, String var2);

    @Message(id=66, value="Exception report")
    public String exceptionReport();

    @Message(id=67, value="Status report")
    public String statusReport();

    @Message(id=68, value="message")
    public String statusMessage();

    @Message(id=69, value="description")
    public String statusDescritpion();

    @Message(id=70, value="exception")
    public String statusException();

    @Message(id=71, value="root cause")
    public String statusRootCause();

    @Message(id=72, value="note")
    public String statusNote();

    @Message(id=73, value="The full stack trace of the root cause is available in the %s logs.")
    public String statusRootCauseInLogs(String var1);

    @Message(id=74, value="Exception processing event.")
    public String eventValveExceptionDuringEvent();

    @Message(id=75, value="Exception processing session listener event.")
    public String eventValveSessionListenerException();

    @Message(id=76, value="Exception performing insert access entry.")
    public String jdbcAccessLogValveInsertError();

    @Message(id=77, value="Exception closing database connection.")
    public String jdbcAccessLogValveConnectionCloseError();

    @Message(id=78, value="Syntax error in request filter pattern %s")
    public String requestFilterValvePatternError(String var1);

    @Message(id=79, value="The property %s is not defined for filters of type %s")
    public String propertyNotFound(String var1, String var2);

    @Message(id=80, value="Unable to create Random source using class %s")
    public String cannotCreateRandom(String var1);

    @Message(id=81, value="Unsupported startingPoint %s")
    public IllegalStateException expiresUnsupportedStartingPoint(String var1);

    @Message(id=82, value="Exception processing configuration parameter %s: %s")
    public String expiresExceptionProcessingParameter(String var1, String var2);

    @Message(id=83, value="Starting point (access|now|modification|a<seconds>|m<seconds>) not found in directive %s")
    public IllegalStateException expiresStartingPointNotFound(String var1);

    @Message(id=84, value="Invalid starting point (access|now|modification|a<seconds>|m<seconds>) %s in directive %s")
    public IllegalStateException expiresInvalidStartingPoint(String var1, String var2);

    @Message(id=85, value="Duration not found in directive %s")
    public IllegalStateException expiresDurationNotFound(String var1);

    @Message(id=86, value="Invalid duration (number) %s in directive %s")
    public IllegalStateException expiresInvalidDuration(String var1, String var2);

    @Message(id=87, value="Duration unit not found after amount %s in directive %s")
    public IllegalStateException expiresDurationUnitNotFound(int var1, String var2);

    @Message(id=88, value="The requested resource (%s) is not available")
    public String resourceNotAvailable(String var1);

    @Message(id=89, value="Directory Listing For %s")
    public String listingDirectoryTitle(String var1);

    @Message(id=90, value="Up To %s")
    public String listingDirectoryParent(String var1);

    @Message(id=91, value="Filename")
    public String listingFilename();

    @Message(id=92, value="Size")
    public String listingSize();

    @Message(id=93, value="Last Modified")
    public String listingLastModified();

    @Message(id=94, value="JAXP initialization failed")
    public String jaxpInitializationFailed();

    @Message(id=95, value="Ignored external entity %s %s")
    public String ignoredExternalEntity(String var1, String var2);

    @Message(id=96, value="No modifications are allowed to a locked ParameterMap")
    public IllegalStateException lockedParameterMap();

    @Message(id=97, value="No modifications are allowed to a locked ResourceSet")
    public IllegalStateException lockedResourceSet();

    @Message(id=98, value="Bad hexadecimal digit")
    public IllegalArgumentException badHexDigit();

    @Message(id=99, value="Odd number of hexadecimal digits")
    public IllegalArgumentException oddNomberOfHexDigits();

    @Message(id=100, value="The client may continue.")
    public String http100();

    @Message(id=101, value="The server is switching protocols according to the 'Upgrade' header.")
    public String http101();

    @Message(id=102, value="The server has accepted the complete request, but has not yet completed it.")
    public String http102();

    @Message(id=103, value="The request succeeded and a new resource has been created on the server.")
    public String http201();

    @Message(id=104, value="This request was accepted for processing, but has not been completed.")
    public String http202();

    @Message(id=105, value="The meta information presented by the client did not originate from the server.")
    public String http203();

    @Message(id=106, value="The request succeeded but there is no information to return.")
    public String http204();

    @Message(id=107, value="The client should reset the document view which caused this request to be sent.")
    public String http205();

    @Message(id=108, value="The server has fulfilled a partial GET request for this resource.")
    public String http206();

    @Message(id=109, value="Multiple status values have been returned.")
    public String http207();

    @Message(id=110, value="This collection binding was already reported.")
    public String http208();

    @Message(id=111, value="The response is a representation of the result of one or more instance-manipulations applied to the current instance.")
    public String http226();

    @Message(id=112, value="The requested resource corresponds to any one of a set of representations, each with its own specific location.")
    public String http300();

    @Message(id=113, value="The requested resource has moved permanently to a new location.")
    public String http301();

    @Message(id=114, value="The requested resource has moved temporarily to a new location.")
    public String http302();

    @Message(id=115, value="The response to this request can be found under a different URI.")
    public String http303();

    @Message(id=116, value="The requested resource is available and has not been modified.")
    public String http304();

    @Message(id=117, value="The requested resource must be accessed through the proxy given by the 'Location' header.")
    public String http305();

    @Message(id=118, value="The requested resource resides temporarily under a different URI.")
    public String http307();

    @Message(id=119, value="The target resource has been assigned a new permanent URI and any future references to this resource SHOULD use one of the returned URIs.")
    public String http308();

    @Message(id=120, value="The request sent by the client was syntactically incorrect.")
    public String http400();

    @Message(id=121, value="This request requires HTTP authentication.")
    public String http401();

    @Message(id=122, value="Payment is required for access to this resource.")
    public String http402();

    @Message(id=123, value="Access to the specified resource has been forbidden.")
    public String http403();

    @Message(id=124, value="The requested resource is not available.")
    public String http404();

    @Message(id=125, value="The specified HTTP method is not allowed for the requested resource.")
    public String http405();

    @Message(id=126, value="The resource identified by this request is only capable of generating responses with characteristics not acceptable according to the request 'Accept' headers.")
    public String http406();

    @Message(id=127, value="The client must first authenticate itself with the proxy.")
    public String http407();

    @Message(id=128, value="The client did not produce a request within the time that the server was prepared to wait.")
    public String http408();

    @Message(id=129, value="The request could not be completed due to a conflict with the current state of the resource.")
    public String http409();

    @Message(id=130, value="The requested resource is no longer available, and no forwarding address is known.")
    public String http410();

    @Message(id=131, value="This request cannot be handled without a defined content length.")
    public String http411();

    @Message(id=132, value="A specified precondition has failed for this request.")
    public String http412();

    @Message(id=133, value="The request entity is larger than the server is willing or able to process.")
    public String http413();

    @Message(id=134, value="The server refused this request because the request URI was too long.")
    public String http414();

    @Message(id=135, value="The server refused this request because the request entity is in a format not supported by the requested resource for the requested method.")
    public String http415();

    @Message(id=136, value="The requested byte range cannot be satisfied.")
    public String http416();

    @Message(id=137, value="The expectation given in the 'Expect' request header could not be fulfilled.")
    public String http417();

    @Message(id=138, value="The server understood the content type and syntax of the request but was unable to process the contained instructions.")
    public String http422();

    @Message(id=139, value="The source or destination resource of a method is locked.")
    public String http423();

    @Message(id=140, value="The method could not be performed on the resource because the requested action depended on another action and that action failed.")
    public String http424();

    @Message(id=141, value="The request can only be completed after a protocol upgrade.")
    public String http426();

    @Message(id=142, value="The request is required to be conditional.")
    public String http428();

    @Message(id=143, value="The user has sent too many requests in a given amount of time.")
    public String http429();

    @Message(id=144, value="The server refused this request because the request header fields are too large.")
    public String http431();

    @Message(id=145, value="The server encountered an internal error that prevented it from fulfilling this request.")
    public String http500();

    @Message(id=146, value="The server does not support the functionality needed to fulfill this request.")
    public String http501();

    @Message(id=147, value="This server received an invalid response from a server it consulted when acting as a proxy or gateway.")
    public String http502();

    @Message(id=148, value="The requested service is not currently available.")
    public String http503();

    @Message(id=149, value="The server received a timeout from an upstream server while acting as a gateway or proxy.")
    public String http504();

    @Message(id=150, value="The server does not support the requested HTTP protocol version.")
    public String http505();

    @Message(id=151, value="The chosen variant resource is configured to engage in transparent content negotiation itself, and is therefore not a proper end point in the negotiation process.")
    public String http506();

    @Message(id=152, value="The resource does not have sufficient space to record the state of the resource after execution of this method.")
    public String http507();

    @Message(id=153, value="The server terminated an operation because it encountered an infinite loop.")
    public String http508();

    @Message(id=154, value="The policy for accessing the resource has not been met in the request.")
    public String http510();

    @Message(id=155, value="The client needs to authenticate to gain network access.")
    public String http511();

    @Message(id=200, value="Store has already been started")
    public String storeAlreadyStarted();

    @Message(id=201, value="Store has not yet been started")
    public String storeNotStarted();

    @Message(id=202, value="Loading Session %s from file %s")
    public String fileStoreSessionLoad(String var1, String var2);

    @Message(id=203, value="Saving Session %s to file %s")
    public String fileStoreSessionSave(String var1, String var2);

    @Message(id=204, value="Removing Session %s at file %s")
    public String fileStoreSessionRemove(String var1, String var2);

    @Message(id=205, value="No persisted data file found")
    public String fileStoreFileNotFound();

    @Message(id=206, value="Parent Container is not a Context")
    public IllegalArgumentException parentNotContext();

    @Message(id=207, value="JDBC Store SQL exception")
    public String jdbcStoreDatabaseError();

    @Message(id=208, value="JDBC driver class not found %s")
    public String jdbcStoreDriverFailure(String var1);

    @Message(id=209, value="Session creation failed due to too many active sessions")
    public IllegalStateException managerMaxActiveSessions();

    @Message(id=210, value="Error deserializing Session %s")
    public IllegalStateException persistentManagerDeserializeError(String var1, @Cause Throwable var2);

    @Message(id=211, value="Session event listener threw exception")
    public String sessionEventListenerException();

    @Message(id=212, value="Session already invalidated")
    public IllegalStateException invalidSession();

    @Message(id=213, value="Exception logging out user when expiring session")
    public String sessionLogoutException();

    @Message(id=214, value="Session attribute event listener threw exception")
    public String sessionAttributeEventListenerException();

    @Message(id=215, value="Session attribute name cannot be null")
    public IllegalArgumentException sessionAttributeNameIsNull();

    @Message(id=216, value="Non-serializable attribute %s")
    public IllegalArgumentException sessionAttributeIsNotSerializable(String var1);

    @Message(id=217, value="Session binding event listener threw exception")
    public String sessionBindingEventListenerException();

    @Message(id=218, value="Cannot serialize session attribute %s for session %s")
    public String sessionAttributeSerializationException(Object var1, String var2);

    @Message(id=219, value="Path %s does not start with a '/' character")
    public IllegalArgumentException invalidDispatcherPath(String var1);

    @Message(id=220, value="Dispatcher mapping error")
    public String dispatcherMappingError();

    @Message(id=221, value="Path %s does not start with a '/' character")
    public String invalidDispatcherPathString(String var1);

    @Message(id=222, value="Exception thrown by attributes event listener")
    public String servletContextAttributeListenerException();

    @Message(id=223, value="Attribute name cannot be null")
    public String servletContextAttributeNameIsNull();

    @Message(id=224, value="The listener that attempted to call this method is restricted")
    public UnsupportedOperationException restrictedListenerCannotCallMethod();

    @Message(id=225, value="Context %s is already initialized")
    public IllegalStateException contextAlreadyInitialized(String var1);

    @Message(id=226, value="Error creating instance")
    public String contextObjectCreationError();

    @Message(id=227, value="Bad listener class %s for context %s")
    public IllegalArgumentException invalidContextListener(String var1, String var2);

    @Message(id=228, value="Bad listener class %s for context %s")
    public IllegalArgumentException invalidContextListenerWithException(String var1, String var2, @Cause Throwable var3);

    @Message(id=229, value="The session tracking mode %s requested for context %s is not supported by that context")
    public IllegalArgumentException unsupportedSessionTrackingMode(String var1, String var2);

    @Message(id=230, value="The session tracking mode SSL requested for context %s cannot be combined with other tracking modes")
    public IllegalArgumentException sslSessionTrackingModeIsExclusive(String var1);

    @Message(id=231, value="Invalid empty role specified for context %s")
    public IllegalArgumentException invalidEmptyRole(String var1);

    @Message(id=232, value="Cannot forward after response has been committed")
    public IllegalStateException cannotForwardAfterCommit();

    @Message(id=233, value="Exception sending request initialized lifecycle event to listener instance of class %s")
    public String requestListenerInitException(String var1);

    @Message(id=234, value="Servlet %s is currently unavailable")
    public String servletIsUnavailable(String var1);

    @Message(id=235, value="Allocate exception for servlet %s")
    public String servletAllocateException(String var1);

    @Message(id=236, value="Servlet.service() for servlet %s threw exception")
    public String servletServiceException(String var1);

    @Message(id=237, value="Deallocate exception for servlet %s")
    public String servletDeallocateException(String var1);

    @Message(id=238, value="Exception sending request destroyed lifecycle event to listener instance of class %s")
    public String requestListenerDestroyException(String var1);

    @Message(id=239, value="Original SevletRequest or wrapped original ServletRequest not passed to RequestDispatcher in violation of SRV.8.2 and SRV.14.2.5.1")
    public String notOriginalRequestInDispatcher();

    @Message(id=240, value="Original SevletResponse or wrapped original ServletResponse not passed to RequestDispatcher in violation of SRV.8.2 and SRV.14.2.5.1")
    public String notOriginalResponseInDispatcher();

    @Message(id=241, value="Context %s has already been initialized")
    public IllegalStateException cannotAddFilterRegistrationAfterInit(String var1);

    @Message(id=242, value="Illegal null or empty argument specified")
    public IllegalArgumentException invalidFilterRegistrationArguments();

    @Message(id=243, value="Context %s has already been initialized")
    public IllegalStateException cannotAddServletRegistrationAfterInit(String var1);

    @Message(id=244, value="Illegal null or empty argument specified")
    public IllegalArgumentException invalidServletRegistrationArguments();

    @Message(id=245, value="Error destroying filter %s")
    public String errorDestroyingFilter(String var1);

    @Message(id=246, value="Exception processing component pre destroy")
    public String preDestroyException();

    @Message(id=247, value="Filter execution threw an exception")
    public String filterException();

    @Message(id=248, value="Servlet execution threw an exception")
    public String servletException();

    @Message(id=249, value="Child container name cannot be null")
    public IllegalArgumentException containerChildWithNullName();

    @Message(id=250, value="Child container with name %s already exists")
    public IllegalArgumentException containerChildNameNotUnique(String var1);

    @Message(id=251, value="Failed to start child container %s")
    public IllegalStateException containerChildStartFailed(String var1, @Cause Throwable var2);

    @Message(id=252, value="Child of an Engine must be a Host")
    public IllegalArgumentException engineChildMustBeHost();

    @Message(id=253, value="Engine cannot have a parent Container")
    public IllegalArgumentException engineHasNoParent();

    @Message(id=254, value="Host name is required")
    public IllegalArgumentException hostNameIsNull();

    @Message(id=255, value="Child of a Host must be a Context")
    public IllegalArgumentException hostChildMustBeContext();

    @Message(id=256, value="Parent of a Wrapper must be a Context")
    public IllegalArgumentException wrapperParentMustBeContext();

    @Message(id=257, value="A Wrapper cannot have a child container")
    public IllegalArgumentException wrapperHasNoChild();

    @Message(id=258, value="Cannot allocate servlet %s because it is being unloaded")
    public String cannotAllocateServletWhileUnloading(String var1);

    @Message(id=259, value="Error allocating a servlet instance")
    public String cannotAllocateServletInstance();

    @Message(id=260, value="No servlet class has been specified for servlet %s")
    public String noClassSpecifiedForServlet(String var1);

    @Message(id=261, value="Class %s is not a Servlet")
    public String specifiedClassIsNotServlet(String var1);

    @Message(id=262, value="Error instantiating servlet class %s")
    public String errorInstantiatingServletClass(String var1);

    @Message(id=263, value="Servlet.init() for servlet %s threw exception")
    public String errorInitializingServlet(String var1);

    @Message(id=264, value="Marking servlet %s as unavailable")
    public String markingServletUnavailable(String var1);

    @Message(id=265, value="Servlet.destroy() for servlet %s threw exception")
    public String errorDestroyingServlet(String var1);

    @Message(id=266, value="Servlet %s threw unload exception")
    public String errorUnloadingServlet(String var1);

    @Message(id=267, value="LoginConfig cannot be null")
    public IllegalArgumentException nullLoginConfig();

    @Message(id=268, value="Form login page %s must start with a ''/'")
    public IllegalArgumentException loginPageMustStartWithSlash(String var1);

    @Message(id=269, value="Error page location %s must start with a ''/''")
    public IllegalArgumentException errorPageMustStartWithSlash(String var1);

    @Message(id=270, value="%s is not a subclass of StandardWrapper")
    public IllegalArgumentException invalidWrapperClass(String var1);

    @Message(id=271, value="Cannot set resources after Context startup")
    public IllegalStateException cannotSetResourcesAfterStart();

    @Message(id=272, value="Child of a Context must be a Wrapper")
    public IllegalArgumentException contextChildMustBeWrapper();

    @Message(id=273, value="JSP file %s must start with a ''/''")
    public IllegalArgumentException jspFileMustStartWithSlash(String var1);

    @Message(id=274, value="Invalid <url-pattern> %s in security constraint")
    public IllegalArgumentException invalidSecurityConstraintUrlPattern(String var1);

    @Message(id=275, value="ErrorPage cannot be null")
    public IllegalArgumentException nullErrorPage();

    @Message(id=276, value="Filter mapping specifies an unknown filter name %s")
    public IllegalArgumentException unknownFilterNameInMapping(String var1);

    @Message(id=277, value="Filter mapping must specify either a <url-pattern> or a <servlet-name>")
    public IllegalArgumentException missingFilterMapping();

    @Message(id=278, value="Invalid <url-pattern> %s in filter mapping")
    public IllegalArgumentException invalidFilterMappingUrlPattern(String var1);

    @Message(id=279, value="Both parameter name and parameter value are required")
    public IllegalArgumentException missingParameterNameOrValue();

    @Message(id=280, value="Duplicate context initialization parameter %s")
    public IllegalArgumentException duplicateContextParameters(String var1);

    @Message(id=281, value="Servlet mapping specifies an unknown Servlet name %s")
    public IllegalArgumentException unknownServletNameInMapping(String var1);

    @Message(id=282, value="Invalid <url-pattern> %s in Servlet mapping")
    public IllegalArgumentException invalidServletMappingUrlPattern(String var1);

    @Message(id=283, value="Create wrapper failed")
    public IllegalStateException errorCreatingWrapper(@Cause Throwable var1);

    @Message(id=284, value="Exception starting filter %s")
    public String errorStartingFilter(String var1);

    @Message(id=285, value="Error configuring application listener of class %s")
    public String errorInstatiatingApplicationListener(String var1);

    @Message(id=286, value="Skipped installing application listeners due to previous error(s)")
    public String skippingApplicationListener();

    @Message(id=287, value="Exception sending context initialized event to listener instance of class %s")
    public String errorSendingContextInitializedEvent(String var1);

    @Message(id=288, value="Error destroying application listener of class %s")
    public String errorDestroyingApplicationListener(String var1);

    @Message(id=289, value="Servlet %s threw load() exception")
    public String errorLoadingServlet(String var1);

    @Message(id=290, value="Error initializing context")
    public String errorInitializingContext();

    @Message(id=291, value="No Context was mapped to process this request")
    public String noContext();

    @Message(id=292, value="Syntax error in IP filter pattern %s")
    public IllegalArgumentException remoteIpValvePatternError(String var1, @Cause Throwable var2);

    @Message(id=293, value="No host [%s] mapped")
    public String noHost(String var1);

    @Message(id=294, value="Servlet %s does not have any instance support")
    public IllegalStateException missingInstanceSupport(String var1);

    @Message(id=295, value="This application is not currently available")
    public String unavailable();

    @Message(id=296, value="Error acknowledging request for Servlet %s")
    public String errorAcknowledgingRequest(String var1);

    @Message(id=297, value="Async listener processing for servlet %s threw exception")
    public String asyncListenerError(String var1);

    @Message(id=298, value="Async runnable processing for servlet %s threw exception")
    public String asyncRunnableError(String var1);

    @Message(id=299, value="Async dispatch processing for servlet %s threw exception")
    public String asyncDispatchError(String var1);

    @Message(id=300, value="Loading Session %s from file %s")
    public String jdbcStoreSessionLoad(String var1, String var2);

    @Message(id=301, value="Saving Session %s to file %s")
    public String jdbcStoreSessionSave(String var1, String var2);

    @Message(id=302, value="Removing Session %s at file %s")
    public String jdbcStoreSessionRemove(String var1, String var2);

    @Message(id=303, value="No persisted data object found")
    public String jdbcStoreIdNotFound();

    @Message(id=304, value="The database connection is null or was found to be closed. Trying to re-open it.")
    public String jdbcStoreConnectionWasClosed();

    @Message(id=305, value="The re-open on the database failed. The database could be down.")
    public String jdbcStoreConnectionReopenFailed();

    @Message(id=306, value="Exception sending context destroyed event to listener instance of class %s")
    public String errorSendingContextDestroyedEvent(String var1);

    @Message(id=307, value="Invalid duration unit (years|months|weeks|days|hours|minutes|seconds) %s in directive %s")
    public IllegalStateException expiresInvalidDurationUnit(String var1, String var2);

    @Message(id=308, value="Request filter invalid pattern %s")
    public IllegalArgumentException requestFilterInvalidPattern(String var1, @Cause Throwable var2);

    @Message(id=309, value="type")
    public String statusType();

    @Message(id=310, value="Null attribute name")
    public IllegalArgumentException invalidNullAttributeName();

    @Message(id=311, value="Null attribute")
    public IllegalArgumentException invalidNullAttribute();

    @Message(id=312, value="Invalid negative read ahead %s specified")
    public IllegalArgumentException invalidReadAhead(int var1);

    @Message(id=313, value="Exception processing error page %s")
    public String errorProcessingErrorPage(String var1);

    @Message(id=314, value="Exception parsing number %s (zero based) of comma delimited list %s")
    public IllegalArgumentException invalidNumberInList(int var1, String var2);

    @Message(id=315, value="Invalid HTTP port number specified %s")
    public IllegalArgumentException invalidHttpPortNumber(String var1);

    @Message(id=316, value="Invalid HTTPS port number specified %s")
    public IllegalArgumentException invalidHttpsPortNumber(String var1);

    @Message(id=317, value="WebDAV client problem: XP-x64-SP2 clients only work with the root context")
    public String webDavClientProblemXpRootOnly();

    @Message(id=318, value="WebDAV client problem: XP-x64-SP2 is known not to work with WebDAV Servlet")
    public String webDavClientProblemXp();

    @Message(id=319, value="Unknown mode %s, must be one of: strict, authOnly, strictAuthOnly")
    public IllegalArgumentException unknownAuthMode(String var1);

    @Message(id=320, value="Running CGI: bad header line: %s")
    public String cgiInvalidHeader(String var1);

    @Message(id=321, value="Error running CGI: %s")
    public String cgiException(String var1);

    @Message(id=322, value="Error closing header reader: %s")
    public String cgiExceptionClosingHeaderReader(String var1);

    @Message(id=323, value="Error closing output stream: %s")
    public String cgiExceptionClosingOutputStream(String var1);

    @Message(id=324, value="Interrupted waiting for stderr reader thread")
    public String cgiInterrupted();

    @Message(id=325, value="Invalid HTTP status line: %s")
    public String cgiInvalidStatusLine(String var1);

    @Message(id=326, value="Invalid status code: %s")
    public String cgiInvalidStatusCode(String var1);

    @Message(id=327, value="Invalid status value: %s")
    public String cgiInvalidStatusValue(String var1);

    @Message(id=328, value="CGI stderr: %s")
    public String cgiErrorLogPrefix(String var1);

    @Message(id=329, value="Error reading error reader")
    public String cgiStderrErrror();

    @Message(id=330, value="XSL transformer error")
    public String xslTransformerError();

    @Message(id=331, value="Session %s expires processing failed")
    public String errorProcessingSessionExpires(String var1);

    @Message(id=332, value="Error removing key %s")
    public String errorRemovingKey(String var1);

    @Message(id=333, value="No nodes created")
    public String ssiParseNoNodes();

    @Message(id=334, value="Extra nodes created")
    public String ssiParseExtraNodes();

    @Message(id=335, value="Unused opp nodes exist")
    public String ssiParseUnusedNodes();

    @Message(id=336, value="Couldn't exec file: %s")
    public String ssiExecFailed(String var1);

    @Message(id=337, value="#%s--Invalid attribute: %s")
    public String ssiInvalidAttribute(String var1, String var2);

    @Message(id=338, value="#flastmod--Couldn't get last modified for file: %s")
    public String ssiFlastmodFailed(String var1);

    @Message(id=339, value="#fsize--Couldn't get size for file: %s")
    public String ssiFsizeFailed(String var1);

    @Message(id=340, value="Num chars can't be negative")
    public IllegalArgumentException invalidNumChars();

    @Message(id=341, value="#include--Couldn't include file: %s")
    public String ssiIncludeFailed(String var1);

    @Message(id=342, value="#echo--Invalid encoding: %s")
    public String ssiEchoInvlidEncoding(String var1);

    @Message(id=343, value="[an error occurred while processing this directive]")
    public String ssiDirectiveError();

    @Message(id=344, value="Unknown encoding: %s")
    public String ssiUnknownEncoding(String var1);

    @Message(id=345, value="Unknown command: %s")
    public String ssiUnknownCommand(String var1);

    @Message(id=346, value="Error parsing command %s parameters")
    public String ssiParsingErrorNoParameters(String var1);

    @Message(id=347, value="Parameter names count does not match parameter values count on command %s")
    public String ssiParsingErrorBadParameterCount(String var1);

    @Message(id=348, value="#set--no variable specified")
    public String ssiSetFailed();

    @Message(id=349, value="Couldn't remove filename from path: %s")
    public String ssiFailedRemovingFilename(String var1);

    @Message(id=350, value="Normalization yielded null on path: %s")
    public String ssiFailedNormalization(String var1);

    @Message(id=351, value="A non-virtual path can't be absolute: %s")
    public String ssiInvalidNonVirtualPath(String var1);

    @Message(id=352, value="A non-virtual path can't contain '../': %s")
    public String ssiInvalidNonVirtualPathWithTraversal(String var1);

    @Message(id=353, value="Couldn't get context for path: %s")
    public String ssiCannotGetContext(String var1);

    @Message(id=354, value="Couldn't remove context from path: %s")
    public String ssiCannotRemoveContext(String var1);

    @Message(id=355, value="Couldn't get request dispatcher for path: %s")
    public String ssiCannotGetRequestDispatcher(String var1);

    @Message(id=356, value="Couldn't find file: %s")
    public String ssiCannotFindFile(String var1);

    @Message(id=357, value="Couldn't include file: %s")
    public String ssiServletIncludeFailed(String var1);

    @Message(id=358, value="Message digest non initialized")
    public IllegalStateException uninitializedMessageDigest();

    @Message(id=359, value="Exception releasing filter %s")
    public String errorStoppingFilter(String var1);
}

