/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ELException;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.parser.SimpleNode;

public final class AstNegative
extends SimpleNode {
    public AstNegative(int id) {
        super(id);
    }

    @Override
    public Class getType(EvaluationContext ctx) throws ELException {
        return Number.class;
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        Object obj = this.children[0].getValue(ctx);
        if (obj == null) {
            return new Long(0L);
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).negate();
        }
        if (obj instanceof BigInteger) {
            return ((BigInteger)obj).negate();
        }
        if (obj instanceof String) {
            if (AstNegative.isStringFloat((String)obj)) {
                return new Double(-Double.parseDouble((String)obj));
            }
            return new Long(-Long.parseLong((String)obj));
        }
        if (obj instanceof Long) {
            return new Long(-((Long)obj).longValue());
        }
        if (obj instanceof Double) {
            return new Double(-((Double)obj).doubleValue());
        }
        if (obj instanceof Integer) {
            return new Integer(-((Integer)obj).intValue());
        }
        if (obj instanceof Float) {
            return new Float(-((Float)obj).floatValue());
        }
        if (obj instanceof Short) {
            return new Short(-((Short)obj).shortValue());
        }
        if (obj instanceof Byte) {
            return new Byte(-((Byte)obj).byteValue());
        }
        Long num = (Long)AstNegative.coerceToNumber(obj, Long.class);
        return new Long(-num.longValue());
    }
}

