/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.tooling;

import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.unit.report.impl.writer.PrintListener;
import org.jboss.unit.runner.ParametrizationSet;
import org.jboss.unit.runner.TestRunner;
import org.jboss.unit.runner.impl.TestRunnerContextSupport;
import org.jboss.unit.runner.impl.TestRunnerEventBroadcaster;
import org.jboss.unit.runner.model.TestSuiteDef;
import org.jboss.unit.tooling.FailureManagerListener;
import org.jboss.unit.tooling.MainBuilder;
import org.jboss.unit.tooling.SystemOutputManager;
import org.jboss.unit.tooling.filter.MainTestFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private final MainTestFilter mainFilter;
    private final TestRunner runner;
    private final TestSuiteDef suiteDef;
    private final Map<String, String> properties;
    private final Map<String, String[]> parameters;
    private final TestRunnerEventBroadcaster broadcaster;
    private final boolean failonerror;
    public static final String JBOSS_UNIT_PROPERTIES = "jboss.unit.properties";
    public static final String JBOSS_UNIT_PROPERTY = "jboss.unit.property";
    public static final String JBOSS_UNIT_PARAMETER = "jboss.unit.parameter";
    public static final String JBOSS_UNIT_PARAMETERS = "jboss.unit.parameters";
    public static final String OPT_FAIL_ON_ERROR = "--failonerror";
    public static final String OPT_ID = "--id";
    public static final String OPT_IDS = "--ids";
    public static final String OPT_KEYWORDS = "--keywords";
    public static final String OPT_EX_ID = "--ex_id";
    public static final String OPT_EX_IDS = "--ex_ids";
    public static final String OPT_EX_KEYWORDS = "--ex_keywords";
    public static final String OPT_CONFIG = "--config";
    public static final String OPT_SUITE_NAME = "--suite_name";
    public static final String OPT_NO_CONSOLE = "--no_console";
    public static final String OPT_XML_REPORT_DIR = "--xml_report_dir";
    public static final String OPT_HTML_REPORT_DIR = "--html_report_dir";
    public static final String OPT_PROPERTY = "--property";
    public static final String OPT_PROPERTIES = "--properties";
    public static final String OPT_PARAMETER = "--parameter";
    public static final String OPT_PARAMETERS = "--parameters";
    public static final Set options;
    public static final Set options_no_arg;

    public Main(TestRunner runner, MainTestFilter mainFilter, TestRunnerEventBroadcaster broadcaster, TestSuiteDef suiteDef, Map<String, String> properties, Map<String, String[]> parameters, boolean failonerror) {
        if (runner == null) {
            throw new IllegalArgumentException("runner cannot be null");
        }
        if (mainFilter == null) {
            throw new IllegalArgumentException("mainFilter cannot be null");
        }
        if (broadcaster == null) {
            throw new IllegalArgumentException("broadcaster cannot be null");
        }
        if (suiteDef == null) {
            throw new IllegalArgumentException("suiteDef cannot be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("parameters cannot be null");
        }
        this.mainFilter = mainFilter;
        this.runner = runner;
        this.suiteDef = suiteDef;
        this.properties = properties;
        this.broadcaster = broadcaster;
        this.parameters = parameters;
        this.failonerror = failonerror;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        SystemOutputManager systemManager = new SystemOutputManager();
        systemManager.start();
        FailureManagerListener failureListener = new FailureManagerListener();
        try {
            System.out.println("TestRunnerContext contains: ");
            System.out.println("Properties: " + this.properties.toString());
            StringWriter sw = new StringWriter();
            this.broadcaster.addListener(new PrintListener(sw));
            this.broadcaster.addListener(failureListener);
            TestRunnerContextSupport runnerContext = new TestRunnerContextSupport(this.properties, new ParametrizationSet(this.parameters), this.mainFilter, this.broadcaster);
            this.runner.run(runnerContext);
            sw.close();
            System.out.println(sw.toString());
        }
        finally {
            systemManager.stop();
            if (this.failonerror && (failureListener.isRunnerFailure() || failureListener.isTestCaseFailure())) {
                System.exit(-1);
            } else {
                System.exit(0);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> arguments = new HashMap<String, String>();
        for (String arg : args) {
            String[] params = arg.split("=", 2);
            if (!options_no_arg.contains(params[0])) {
                if (params.length < 2) {
                    throw new IllegalArgumentException("Argument '" + arg + "' doesn't follow the name=value pattern");
                }
                arguments.put(params[0], params[1]);
                continue;
            }
            arguments.put(params[0], null);
        }
        if (!arguments.keySet().contains(OPT_CONFIG)) {
            throw new IllegalArgumentException("Argument '--config' is missing");
        }
        MainBuilder builder = null;
        if (arguments.keySet().contains(OPT_SUITE_NAME)) {
            builder = new MainBuilder((String)arguments.get(OPT_CONFIG), (String)arguments.get(OPT_SUITE_NAME));
            builder.setSuiteName((String)arguments.get(OPT_SUITE_NAME));
        } else {
            builder = new MainBuilder((String)arguments.get(OPT_CONFIG));
        }
        for (String argument : arguments.keySet()) {
            if (argument.equals(OPT_IDS)) {
                builder.addUnparsedNames((String)arguments.get(OPT_IDS));
            }
            if (argument.equals(OPT_ID)) {
                builder.addName((String)arguments.get(OPT_ID));
            }
            if (argument.equals(OPT_KEYWORDS)) {
                builder.addUnparsedKeywords((String)arguments.get(OPT_KEYWORDS));
            }
            if (argument.equals(OPT_EX_IDS)) {
                builder.addUnparsedExcludeNames((String)arguments.get(OPT_EX_IDS));
            }
            if (argument.equals(OPT_EX_ID)) {
                builder.addExcludeName((String)arguments.get(OPT_EX_ID));
            }
            if (argument.equals(OPT_EX_KEYWORDS)) {
                builder.addUnparsedExcludeKeywords((String)arguments.get(OPT_EX_KEYWORDS));
            }
            if (argument.equals(OPT_NO_CONSOLE)) {
                builder.setNoConsole(true);
            }
            if (argument.equals(OPT_FAIL_ON_ERROR)) {
                builder.setFailonerror(true);
            }
            if (argument.equals(OPT_XML_REPORT_DIR)) {
                builder.setXMLReportDir((String)arguments.get(OPT_XML_REPORT_DIR));
            }
            if (argument.equals(OPT_HTML_REPORT_DIR)) {
                builder.setHTMLReportDir((String)arguments.get(OPT_HTML_REPORT_DIR));
            }
            if (argument.startsWith(OPT_PROPERTY) && !argument.equals(OPT_PROPERTIES)) {
                builder.addUnparsedProperty(argument + (String)arguments.get(OPT_PROPERTY));
            }
            if (argument.equals(OPT_PROPERTIES)) {
                builder.addUnparsedProperties((String)arguments.get(OPT_PROPERTIES));
            }
            if (argument.startsWith(OPT_PARAMETER) && !argument.equals(OPT_PARAMETERS)) {
                builder.addUnparsedParameter(argument + (String)arguments.get(OPT_PARAMETER));
            }
            if (!argument.equals(OPT_PARAMETERS)) continue;
            builder.addUnparsedParameters((String)arguments.get(OPT_PARAMETERS));
        }
        Main main = builder.build();
        main.execute();
    }

    static {
        HashSet<String> opts = new HashSet<String>();
        opts.add(OPT_ID);
        opts.add(OPT_IDS);
        opts.add(OPT_KEYWORDS);
        opts.add(OPT_EX_ID);
        opts.add(OPT_EX_IDS);
        opts.add(OPT_EX_KEYWORDS);
        opts.add(OPT_CONFIG);
        opts.add(OPT_SUITE_NAME);
        opts.add(OPT_NO_CONSOLE);
        opts.add(OPT_XML_REPORT_DIR);
        opts.add(OPT_HTML_REPORT_DIR);
        opts.add(OPT_PROPERTY);
        opts.add(OPT_FAIL_ON_ERROR);
        options = Collections.unmodifiableSet(opts);
        opts = new HashSet();
        opts.add(OPT_NO_CONSOLE);
        opts.add(OPT_FAIL_ON_ERROR);
        options_no_arg = Collections.unmodifiableSet(opts);
    }
}

