/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.spi.pojo;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

class MethodKey
implements Comparable {
    private String name;
    private List<String> types;

    MethodKey(Method method) {
        ArrayList<String> types = new ArrayList<String>();
        for (Class<?> type : method.getParameterTypes()) {
            types.add(type.getName());
        }
        this.name = method.getName();
        this.types = types;
    }

    public int hashCode() {
        return this.name.hashCode() + ((Object)this.types).hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MethodKey) {
            MethodKey that = (MethodKey)object;
            return that.name.equals(this.name) && ((Object)that.types).equals(this.types);
        }
        return false;
    }

    public int compareTo(Object o) {
        MethodKey that = (MethodKey)o;
        int sign = this.name.compareTo(that.name);
        if (sign != 0) {
            return sign;
        }
        for (int index = 0; index < this.types.size() && index < that.types.size(); ++index) {
            String thatName;
            String thisName = this.types.get(index);
            int order = thisName.compareTo(thatName = that.types.get(index));
            if (order == 0) continue;
            return order;
        }
        return that.types.size() - this.types.size();
    }
}

