/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.runner.impl;

import java.util.ArrayList;
import java.util.List;
import org.jboss.unit.runner.TestRunnerEvent;
import org.jboss.unit.runner.TestRunnerEventListener;

public class TestRunnerEventBroadcaster
implements TestRunnerEventListener {
    private List<TestRunnerEventListener> listeners = new ArrayList<TestRunnerEventListener>();

    public void addListener(TestRunnerEventListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("No null listener accepted");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(TestRunnerEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("No null listener accepted");
        }
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void onEvent(TestRunnerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        for (TestRunnerEventListener listener : this.listeners) {
            try {
                listener.onEvent(event);
            }
            catch (Exception e) {}
        }
    }
}

