/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.info.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.unit.info.ParameterInfo;
import org.jboss.unit.info.TestCaseInfo;
import org.jboss.unit.info.TestInfo;
import org.jboss.unit.info.TestSuiteInfo;
import org.jboss.unit.info.impl.SimpleParameterInfo;
import org.jboss.unit.info.impl.SimpleTestCaseInfo;
import org.jboss.unit.info.impl.SimpleTestSuiteInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleTestInfo
implements TestInfo {
    protected final String name;
    protected String description;
    protected Map<String, SimpleParameterInfo> parameters;
    protected Set<String> keywords;

    public SimpleTestInfo(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.description = null;
        this.parameters = new HashMap<String, SimpleParameterInfo>();
        this.keywords = new HashSet<String>();
    }

    public SimpleTestInfo(TestInfo that) {
        if (that == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, SimpleParameterInfo> parameters = new HashMap<String, SimpleParameterInfo>();
        for (Map.Entry<String, ? extends ParameterInfo> entry : that.getParameters().entrySet()) {
            parameters.put(entry.getKey(), new SimpleParameterInfo(entry.getValue()));
        }
        this.name = that.getName();
        this.description = that.getDescription();
        this.keywords = new HashSet<String>(that.getKeywords());
        this.parameters = parameters;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, SimpleParameterInfo> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public Set<String> getKeywords() {
        return Collections.unmodifiableSet(this.keywords);
    }

    public void setKeywords(Set<String> keywords) {
        if (keywords == null) {
            throw new IllegalArgumentException();
        }
        this.keywords = new HashSet<String>(keywords);
    }

    public static SimpleTestInfo create(TestInfo testInfo) throws IllegalArgumentException {
        if (testInfo == null) {
            throw new IllegalArgumentException();
        }
        if (testInfo instanceof TestSuiteInfo) {
            TestSuiteInfo testSuite = (TestSuiteInfo)testInfo;
            return new SimpleTestSuiteInfo(testSuite);
        }
        TestCaseInfo testCase = (TestCaseInfo)testInfo;
        return new SimpleTestCaseInfo(testCase);
    }
}

