/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.driver.impl.composite;

import java.util.Set;
import org.jboss.unit.Failure;
import org.jboss.unit.TestId;
import org.jboss.unit.driver.AbstractTestDriver;
import org.jboss.unit.driver.DriverCommand;
import org.jboss.unit.driver.DriverResponse;
import org.jboss.unit.driver.TestDriver;
import org.jboss.unit.driver.response.FailureResponse;
import org.jboss.unit.info.TestInfo;
import org.jboss.unit.info.impl.SimpleTestInfo;
import org.jboss.unit.info.impl.SimpleTestSuiteInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompositeTestDriver
extends AbstractTestDriver {
    @Override
    public TestInfo getInfo() {
        SimpleTestSuiteInfo info = new SimpleTestSuiteInfo(this.getName());
        for (String name : this.getNames()) {
            TestDriver driver = this.getDriver(name);
            info.addTest(SimpleTestInfo.create(driver.getInfo()));
        }
        return info;
    }

    @Override
    public DriverResponse invoke(TestId id, DriverCommand command) {
        if (id.getLength() == 0) {
            return new FailureResponse(Failure.createErrorFailure("No null test id accepted"));
        }
        String name = id.getName(0);
        TestDriver driver = this.getDriver(name);
        if (driver == null) {
            return new FailureResponse(Failure.createErrorFailure("No test driver found for name " + name));
        }
        TestId driverId = id.range(1);
        return driver.invoke(driverId, command);
    }

    public abstract String getName();

    public abstract TestDriver getDriver(String var1);

    public abstract Set<String> getNames();
}

