/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.api.pojo.junit;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.jboss.unit.api.pojo.junit.JUnitProvider;
import org.jboss.unit.api.pojo.junit.JUnitTestMethod;
import org.jboss.unit.api.pojo.junit.JUnitTestMethodLifeCycle;
import org.jboss.unit.api.pojo.junit.TestCase;
import org.jboss.unit.spi.pojo.TestCaseLifeCycleException;
import org.jboss.unit.spi.pojo.TestLifeCycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JUnitLifeCycle
implements TestLifeCycle {
    private final JUnitProvider provider;

    public JUnitLifeCycle(JUnitProvider testCase) {
        this.provider = testCase;
    }

    @Override
    public org.jboss.unit.spi.pojo.TestCase newTestCase(String name) throws TestCaseLifeCycleException {
        JUnitTestMethod method = this.provider.descriptor.testMap.get(name);
        if (method == null) {
            throw new TestCaseLifeCycleException("No test case " + name + " found");
        }
        try {
            TestCase testCase = (TestCase)this.provider.testClass.newInstance();
            return new JUnitTestMethodLifeCycle(testCase, method);
        }
        catch (InstantiationException e) {
            throw new TestCaseLifeCycleException(e);
        }
        catch (IllegalAccessException e) {
            throw new TestCaseLifeCycleException(e);
        }
    }

    @Override
    public void testCaseParametrize(org.jboss.unit.spi.pojo.TestCase testCase, Map<String, String> parametrization) throws TestCaseLifeCycleException {
    }

    @Override
    public void testCaseCreate(org.jboss.unit.spi.pojo.TestCase testCase) throws TestCaseLifeCycleException {
        try {
            JUnitTestMethodLifeCycle lifeCycle = (JUnitTestMethodLifeCycle)testCase;
            lifeCycle.pojo.setUp();
        }
        catch (Throwable e) {
            throw this.unwrap(e);
        }
    }

    @Override
    public void testCaseInvoke(org.jboss.unit.spi.pojo.TestCase testCase) throws TestCaseLifeCycleException {
        JUnitTestMethodLifeCycle lifeCycle = (JUnitTestMethodLifeCycle)testCase;
        try {
            lifeCycle.testMethod.method.invoke((Object)lifeCycle.pojo, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw this.unwrap(e);
        }
        catch (InvocationTargetException e) {
            throw this.unwrap(e.getCause());
        }
    }

    private TestCaseLifeCycleException unwrap(Throwable throwable) {
        for (Class<?> clazz = throwable.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!"junit.framework.AssertionFailedError".equals(clazz.getName())) continue;
            return new TestCaseLifeCycleException((Throwable)((Object)new AssertionError((Object)throwable)));
        }
        return new TestCaseLifeCycleException(throwable);
    }

    @Override
    public void testCaseDestroy(org.jboss.unit.spi.pojo.TestCase testCase) {
        try {
            JUnitTestMethodLifeCycle lifeCycle = (JUnitTestMethodLifeCycle)testCase;
            lifeCycle.pojo.tearDown();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

