/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.tooling;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.jboss.unit.tooling.ByteArrayOutputStreamExt;

public class SystemOutputView {
    private ByteArrayOutputStreamExt out;
    private ByteArrayOutputStreamExt err;
    private int outCount;
    private int errCount;

    public SystemOutputView(ByteArrayOutputStreamExt out, ByteArrayOutputStreamExt err, boolean fullHistory) {
        this.out = out;
        this.err = err;
        this.outCount = fullHistory ? 0 : out.size();
        this.errCount = fullHistory ? 0 : err.size();
    }

    public void writeTo(OutputStream toOut, OutputStream toErr) throws IOException {
        this.outCount = this.out.writeTo(toOut, this.outCount);
        this.errCount = this.err.writeTo(toErr, this.errCount);
    }

    public void writeTo(Writer toOut, Writer toErr) throws IOException {
        this.outCount = this.out.writeTo(toOut, this.outCount);
        this.errCount = this.err.writeTo(toErr, this.errCount);
    }

    public void reset() {
        this.outCount = 0;
        this.errCount = 0;
    }
}

