/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.runner.model.pojo;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.unit.runner.model.ParametersDef;
import org.jboss.unit.runner.model.pojo.TestCaseDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestClassDef {
    private String name;
    private Map<String, TestCaseDef> testCases = new HashMap<String, TestCaseDef>();
    private ParametersDef parameters = new ParametersDef();
    private Map<String, String> properties = new HashMap<String, String>();

    public TestClassDef(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No null name accepted");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Collection<TestCaseDef> getTestCases() {
        return this.testCases.values();
    }

    public void addTestCase(TestCaseDef testCaseDef) {
        if (testCaseDef == null) {
            throw new IllegalArgumentException("No null test case accepted");
        }
        this.testCases.put(testCaseDef.getName(), testCaseDef);
    }

    public TestCaseDef getTestCase(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No null test case name accepted");
        }
        return this.testCases.get(name);
    }

    public ParametersDef getParameters() {
        return this.parameters;
    }

    public void setParameters(ParametersDef parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setProperty(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }
}

