/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.driver.impl.composite;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.unit.driver.DriverException;
import org.jboss.unit.driver.TestDriver;
import org.jboss.unit.driver.impl.composite.AbstractCompositeTestDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeTestDriver
extends AbstractCompositeTestDriver {
    private final String name;
    protected final Map<String, TestDriver> drivers = new HashMap<String, TestDriver>();

    public CompositeTestDriver() {
        this("Main");
    }

    public CompositeTestDriver(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TestDriver getDriver(String name) {
        return this.drivers.get(name);
    }

    @Override
    public Set<String> getNames() {
        return this.drivers.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mount(TestDriver driver) throws DriverException {
        Class<TestDriver> clazz = TestDriver.class;
        synchronized (TestDriver.class) {
            driver.initDriver(this.getContext());
            String name = driver.getInfo().getName();
            this.drivers.put(name, driver);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unmount(TestDriver driver) {
        Class<TestDriver> clazz = TestDriver.class;
        synchronized (TestDriver.class) {
            String name = driver.getInfo().getName();
            this.drivers.remove(name);
            driver.destroyDriver();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

