/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.jboss.threads.ExtendedLock;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.JDKSpecific;
import org.wildfly.common.Assert;

public class SpinLock
implements ExtendedLock {
    private static final long ownerOffset;
    private volatile Thread owner;

    @Override
    public boolean isLocked() {
        return this.owner != null;
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return this.owner == Thread.currentThread();
    }

    @Override
    public boolean isFair() {
        return true;
    }

    @Override
    public void lock() {
        while (true) {
            Thread owner;
            if ((owner = this.owner) == Thread.currentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (owner == null && JBossExecutors.unsafe.compareAndSwapObject(this, ownerOffset, null, Thread.currentThread())) {
                return;
            }
            JDKSpecific.onSpinWait();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread owner = this.owner;
            if (owner == Thread.currentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (owner == null && JBossExecutors.unsafe.compareAndSwapObject(this, ownerOffset, null, Thread.currentThread())) {
                return;
            }
            JDKSpecific.onSpinWait();
        }
    }

    @Override
    public boolean tryLock() {
        return JBossExecutors.unsafe.compareAndSwapObject(this, ownerOffset, null, Thread.currentThread());
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) {
        throw Assert.unsupported();
    }

    @Override
    public void unlock() {
        if (!JBossExecutors.unsafe.compareAndSwapObject(this, ownerOffset, Thread.currentThread(), null)) {
            throw new IllegalMonitorStateException();
        }
    }

    @Override
    public Condition newCondition() {
        throw Assert.unsupported();
    }

    static {
        try {
            ownerOffset = JBossExecutors.unsafe.objectFieldOffset(SpinLock.class.getDeclaredField("owner"));
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldError(e.getMessage());
        }
    }
}

