/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.threads.AtomicArray;
import org.wildfly.common.Assert;

public class BalancingExecutor
implements Executor {
    private static final Executor[] NO_EXECUTORS = new Executor[0];
    private volatile Executor[] executors = NO_EXECUTORS;
    private static final AtomicArray<BalancingExecutor, Executor> executorsUpdater = AtomicArray.create(AtomicReferenceFieldUpdater.newUpdater(BalancingExecutor.class, Executor[].class, "executors"), NO_EXECUTORS);

    public BalancingExecutor() {
    }

    public BalancingExecutor(Executor ... executors) {
        if (executors != null && executors.length > 0) {
            Executor[] clone = (Executor[])executors.clone();
            for (int i = 0; i < clone.length; ++i) {
                Assert.checkNotNullArrayParam((String)"executors", (int)i, (Object)clone[i]);
            }
            executorsUpdater.set(this, (Executor[])clone);
        } else {
            executorsUpdater.clear(this);
        }
    }

    @Override
    public void execute(Runnable command) throws RejectedExecutionException {
        Executor[] executors = this.executors;
        int len = executors.length;
        if (len == 0) {
            throw new RejectedExecutionException("No executors available to run task");
        }
        executors[ThreadLocalRandom.current().nextInt(len)].execute(command);
    }

    public void clear() {
        executorsUpdater.clear(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExecutor(Executor executor) {
        Assert.checkNotNullParam((String)"executor", (Object)executor);
        BalancingExecutor balancingExecutor = this;
        synchronized (balancingExecutor) {
            executorsUpdater.add(this, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExecutor(Executor executor) {
        if (executor == null) {
            return;
        }
        BalancingExecutor balancingExecutor = this;
        synchronized (balancingExecutor) {
            executorsUpdater.remove(this, executor, true);
        }
    }
}

