/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.logging.Logger;
import org.jboss.threads.DirectExecutor;
import org.jboss.threads.ExecutionInterruptedException;
import org.jboss.threads.StoppedExecutorException;
import org.jboss.threads.ThreadCreationException;
import org.jboss.threads.management.BoundedThreadPoolExecutorMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueuelessExecutor
extends AbstractExecutorService
implements ExecutorService,
BoundedThreadPoolExecutorMBean {
    private static final Logger log = Logger.getLogger((String)"org.jboss.threads.executor");
    private final ThreadFactory threadFactory;
    private final DirectExecutor taskExecutor;
    private final Lock lock = new ReentrantLock(false);
    private final Condition runnableDequeued = this.lock.newCondition();
    private final Condition nextReady = this.lock.newCondition();
    private final Condition workerDequeued = this.lock.newCondition();
    private final Condition taskEnqueued = this.lock.newCondition();
    private final Condition threadDeath = this.lock.newCondition();
    private final Set<Thread> runningThreads = new HashSet<Thread>(256);
    private Runnable workRunnable;
    private Worker waitingWorker;
    private long keepAliveTime;
    private int maxThreads;
    private boolean blocking;
    private Executor handoffExecutor;
    private boolean stop;
    private int largestPoolSize;
    private int rejectedCount;

    public QueuelessExecutor(ThreadFactory threadFactory, DirectExecutor taskExecutor, Executor handoffExecutor, long keepAliveTime) {
        this.threadFactory = threadFactory;
        this.taskExecutor = taskExecutor;
        this.handoffExecutor = handoffExecutor;
        this.keepAliveTime = keepAliveTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxThreads() {
        Lock lock = this.lock;
        lock.lock();
        try {
            int n = this.maxThreads;
            Object var4_3 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxThreads(int newSize) {
        if (newSize < 1) {
            throw new IllegalArgumentException("Pool size must be at least 1");
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            this.maxThreads = newSize;
            Object var4_3 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getKeepAliveTime() {
        Lock lock = this.lock;
        lock.lock();
        try {
            long l = this.keepAliveTime;
            Object var5_3 = null;
            lock.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setKeepAliveTime(long milliseconds) {
        Lock lock = this.lock;
        lock.lock();
        try {
            this.keepAliveTime = milliseconds;
            Object var5_3 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentThreadCount() {
        Lock lock = this.lock;
        lock.lock();
        try {
            int n = this.runningThreads.size();
            Object var4_3 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLargestThreadCount() {
        Lock lock = this.lock;
        lock.lock();
        try {
            int n = this.largestPoolSize;
            Object var4_3 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRejectedCount() {
        Lock lock = this.lock;
        lock.lock();
        try {
            int n = this.rejectedCount;
            Object var4_3 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBlocking() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.blocking;
            Object var4_3 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlocking(boolean blocking) {
        Lock lock = this.lock;
        lock.lock();
        try {
            this.blocking = blocking;
            Object var4_3 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Executor getHandoffExecutor() {
        Lock lock = this.lock;
        lock.lock();
        try {
            Executor executor = this.handoffExecutor;
            Object var4_3 = null;
            lock.unlock();
            return executor;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHandoffExecutor(Executor handoffExecutor) {
        Lock lock = this.lock;
        lock.lock();
        try {
            this.handoffExecutor = handoffExecutor;
            Object var4_3 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Lock lock = this.lock;
        lock.lock();
        try {
            if (!this.stop) {
                for (Thread runningThread : this.runningThreads) {
                    runningThread.interrupt();
                }
            }
            this.stop = true;
            this.runnableDequeued.signalAll();
            this.nextReady.signalAll();
            this.workerDequeued.signalAll();
            this.taskEnqueued.signalAll();
            Object var5_4 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Lock lock = this.lock;
        lock.lock();
        try {
            if (!this.stop) {
                throw new IllegalStateException("Not shut down");
            }
            Date deadline = new Date(QueuelessExecutor.clipHigh(unit.toMillis(timeout) + System.currentTimeMillis()));
            Condition threadDeath = this.threadDeath;
            while (!this.runningThreads.isEmpty() && threadDeath.awaitUntil(deadline)) {
            }
            boolean bl = this.runningThreads.isEmpty();
            Object var9_7 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            lock.unlock();
            throw throwable;
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.stop;
            Object var4_3 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.stop && this.runningThreads.isEmpty();
            Object var4_3 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(Runnable command) {
        block19: {
            block21: {
                block18: {
                    runningThreads = this.runningThreads;
                    runnableDequeued = this.runnableDequeued;
                    lock = this.lock;
                    lock.lock();
                    try lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (this.stop) {
                                throw new StoppedExecutorException("Executor has been shut down");
                            }
                            waitingWorker = this.waitingWorker;
                            if (waitingWorker != null) {
                                Worker.access$000(waitingWorker, command);
                                this.taskEnqueued.signal();
                                this.waitingWorker = null;
                                var13_9 = null;
                                lock.unlock();
                                return;
                            }
                            currentSize = runningThreads.size();
                            if (currentSize < this.maxThreads) {
                                thread = this.threadFactory.newThread(new Worker(command));
                                if (thread == null) {
                                    throw new ThreadCreationException();
                                }
                                if (!runningThreads.add(thread)) {
                                    throw new ThreadCreationException("Unable to add new thread to the running set");
                                }
                                if (currentSize >= this.largestPoolSize) {
                                    this.largestPoolSize = currentSize + 1;
                                }
                                thread.start();
                                break block18;
                            }
                            if (!this.blocking) {
                                executor = this.handoffExecutor;
                                ++this.rejectedCount;
                                break block19;
                            }
                            workRunnable = this.workRunnable;
                            if (workRunnable != null) {
                                try {
                                    this.nextReady.await();
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    throw new ExecutionInterruptedException();
                                }
                            }
                            this.workRunnable = command;
                            try {
                                runnableDequeued.await();
                                if (this.workRunnable != null) break;
                                this.nextReady.signal();
                                var11_8 = null;
                                this.workRunnable = null;
                                break block21;
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw new ExecutionInterruptedException();
                            }
                            catch (Throwable var10_18) {
                                var11_8 = null;
                                this.workRunnable = null;
                                throw var10_18;
                            }
                            break;
                        }
                        var11_8 = null;
                        this.workRunnable = null;
                        ** continue;
                    }
                    catch (Throwable var12_19) {
                        var13_13 = null;
                        lock.unlock();
                        throw var12_19;
                    }
                }
                var13_10 = null;
                lock.unlock();
                return;
            }
            var13_11 = null;
            lock.unlock();
            return;
        }
        var13_12 = null;
        lock.unlock();
        if (executor == null) throw new RejectedExecutionException();
        executor.execute(command);
    }

    private static long clipHigh(long value) {
        return value < 0L ? Long.MAX_VALUE : value;
    }

    static /* synthetic */ Lock access$500(QueuelessExecutor x0) {
        return x0.lock;
    }

    static /* synthetic */ Condition access$600(QueuelessExecutor x0) {
        return x0.workerDequeued;
    }

    static /* synthetic */ Condition access$700(QueuelessExecutor x0) {
        return x0.runnableDequeued;
    }

    static /* synthetic */ Condition access$800(QueuelessExecutor x0) {
        return x0.taskEnqueued;
    }

    static /* synthetic */ Set access$900(QueuelessExecutor x0) {
        return x0.runningThreads;
    }

    static /* synthetic */ DirectExecutor access$1000(QueuelessExecutor x0) {
        return x0.taskExecutor;
    }

    static /* synthetic */ Logger access$1100() {
        return log;
    }

    static /* synthetic */ int access$1200(QueuelessExecutor x0) {
        return x0.maxThreads;
    }

    static /* synthetic */ Condition access$1300(QueuelessExecutor x0) {
        return x0.threadDeath;
    }

    static /* synthetic */ Runnable access$1400(QueuelessExecutor x0) {
        return x0.workRunnable;
    }

    static /* synthetic */ Runnable access$1402(QueuelessExecutor x0, Runnable x1) {
        x0.workRunnable = x1;
        return x0.workRunnable;
    }

    static /* synthetic */ Worker access$1500(QueuelessExecutor x0) {
        return x0.waitingWorker;
    }

    static /* synthetic */ Worker access$1502(QueuelessExecutor x0, Worker x1) {
        x0.waitingWorker = x1;
        return x0.waitingWorker;
    }

    private final class Worker
    implements Runnable {
        private Runnable runnable;

        private Worker(Runnable runnable) {
            this.runnable = runnable;
        }

        private void setRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        private boolean awaitTimed(Condition condition, long idleSince) {
            long end = QueuelessExecutor.clipHigh(System.currentTimeMillis() + QueuelessExecutor.this.keepAliveTime);
            long remaining = end - idleSince;
            if (remaining < 0L) {
                return false;
            }
            if (QueuelessExecutor.this.stop) {
                return false;
            }
            try {
                condition.await(remaining, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return !QueuelessExecutor.this.stop;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 17[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        static /* synthetic */ void access$000(Worker x0, Runnable x1) {
            x0.setRunnable(x1);
        }
    }
}

