/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import org.jboss.threads.InterruptHandler;

public final class JBossThread
extends Thread {
    private final InterruptHandler[] interruptHandlers;

    public JBossThread(InterruptHandler[] handlers, ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, target, name, stackSize);
        this.interruptHandlers = handlers;
    }

    public JBossThread(InterruptHandler[] handlers, ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
        this.interruptHandlers = handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        try {
            super.interrupt();
        }
        finally {
            if (this.interruptHandlers != null) {
                for (InterruptHandler interruptHandler : this.interruptHandlers) {
                    try {
                        interruptHandler.handleInterrupt(this);
                    }
                    catch (Throwable t) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        super.run();
    }
}

