/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.threads.RejectionPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleQueueExecutor
extends AbstractExecutorService
implements ExecutorService {
    private final Lock lock = new ReentrantLock();
    private final Condition enqueueCondition = this.lock.newCondition();
    private final Condition removeCondition = this.lock.newCondition();
    private final Condition threadExitCondition = this.lock.newCondition();
    private final ThreadFactory threadFactory;
    private int coreThreadLimit;
    private int maxThreadLimit;
    private boolean allowCoreThreadTimeout;
    private long keepAliveTime;
    private TimeUnit keepAliveTimeUnit;
    private RejectionPolicy rejectionPolicy;
    private Executor handoffExecutor;
    private int threadCount;
    private Set<Thread> workers = new HashSet<Thread>();
    private boolean stop;
    private boolean interrupt;
    private Queue<Runnable> queue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleQueueExecutor(int coreThreadLimit, int maxThreadLimit, long keepAliveTime, TimeUnit keepAliveTimeUnit, Queue<Runnable> queue, ThreadFactory threadFactory, RejectionPolicy rejectionPolicy, Executor handoffExecutor) {
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory is null");
        }
        if (queue == null) {
            throw new NullPointerException("queue is null");
        }
        if (keepAliveTimeUnit == null) {
            throw new NullPointerException("keepAliveTimeUnit is null");
        }
        if (rejectionPolicy == null) {
            throw new NullPointerException("rejectionPolicy is null");
        }
        if (rejectionPolicy == RejectionPolicy.HANDOFF && handoffExecutor == null) {
            throw new NullPointerException("handoffExecutor is null");
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            this.threadFactory = threadFactory;
            this.keepAliveTime = keepAliveTime;
            this.keepAliveTimeUnit = keepAliveTimeUnit;
            this.coreThreadLimit = coreThreadLimit;
            this.maxThreadLimit = maxThreadLimit;
            this.queue = queue;
            this.rejectionPolicy = rejectionPolicy;
            this.handoffExecutor = handoffExecutor;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void execute(Runnable task) throws RejectedExecutionException {
        Lock lock = this.lock;
        try {
            lock.lockInterruptibly();
            try {
                while (true) {
                    if (this.stop) {
                        throw new RejectedExecutionException("Executor is stopped");
                    }
                    int count = this.threadCount;
                    if (count < this.coreThreadLimit) {
                        this.startNewThread(task);
                        this.threadCount = count + 1;
                        return;
                    }
                    Queue<Runnable> queue = this.queue;
                    if (queue.offer(task)) {
                        this.enqueueCondition.signal();
                        return;
                    }
                    if (count < this.maxThreadLimit) {
                        this.startNewThread(task);
                        this.threadCount = count + 1;
                        return;
                    }
                    switch (this.rejectionPolicy) {
                        case ABORT: {
                            throw new RejectedExecutionException("Executor is busy");
                        }
                        case BLOCK: {
                            this.removeCondition.await();
                            break;
                        }
                        case DISCARD: {
                            return;
                        }
                        case DISCARD_OLDEST: {
                            if (queue.poll() != null) {
                                queue.add(task);
                                this.enqueueCondition.signal();
                            }
                            return;
                        }
                        case HANDOFF: {
                            this.handoffExecutor.execute(task);
                            return;
                        }
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RejectedExecutionException("Thread interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Lock lock = this.lock;
        lock.lock();
        try {
            if (!this.stop) {
                this.stop = true;
                this.removeCondition.signalAll();
                this.enqueueCondition.signalAll();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        Lock lock = this.lock;
        lock.lock();
        try {
            this.stop = true;
            this.interrupt = true;
            this.removeCondition.signalAll();
            this.enqueueCondition.signalAll();
            for (Thread worker : this.workers) {
                worker.interrupt();
            }
            Queue<Runnable> queue = this.queue;
            ArrayList<Runnable> list = new ArrayList<Runnable>(queue);
            queue.clear();
            ArrayList<Runnable> arrayList = list;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.stop;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.stop && this.threadCount == 0;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Lock lock = this.lock;
        lock.lockInterruptibly();
        try {
            long start = System.currentTimeMillis();
            long elapsed = 0L;
            while (!this.stop && this.threadCount > 0) {
                long remaining = timeout - elapsed;
                if (remaining <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                this.threadExitCondition.await(remaining, unit);
                elapsed = unit.convert(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAllowCoreThreadTimeout() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.allowCoreThreadTimeout;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowCoreThreadTimeout(boolean allowCoreThreadTimeout) {
        Lock lock = this.lock;
        lock.lock();
        try {
            this.allowCoreThreadTimeout = allowCoreThreadTimeout;
            if (allowCoreThreadTimeout) {
                this.enqueueCondition.signalAll();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCoreThreadLimit() {
        Lock lock = this.lock;
        lock.lock();
        try {
            int n = this.coreThreadLimit;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoreThreadLimit(int coreThreadLimit) {
        Lock lock = this.lock;
        lock.lock();
        try {
            int oldLimit = this.coreThreadLimit;
            if (this.maxThreadLimit < coreThreadLimit) {
                this.setMaxThreadLimit(coreThreadLimit);
            } else if (oldLimit < coreThreadLimit) {
                this.removeCondition.signalAll();
            } else if (oldLimit > coreThreadLimit) {
                this.enqueueCondition.signalAll();
            } else {
                return;
            }
            this.coreThreadLimit = coreThreadLimit;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxThreadLimit() {
        Lock lock = this.lock;
        lock.lock();
        try {
            int n = this.maxThreadLimit;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxThreadLimit(int maxThreadLimit) {
        Lock lock = this.lock;
        lock.lock();
        try {
            int oldLimit = this.maxThreadLimit;
            if (maxThreadLimit < this.coreThreadLimit) {
                this.setCoreThreadLimit(maxThreadLimit);
            } else if (oldLimit < maxThreadLimit) {
                this.removeCondition.signalAll();
            } else if (oldLimit > maxThreadLimit) {
                this.enqueueCondition.signalAll();
            } else {
                return;
            }
            this.maxThreadLimit = maxThreadLimit;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getKeepAliveTime() {
        Lock lock = this.lock;
        lock.lock();
        try {
            long l = this.keepAliveTime;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeUnit getKeepAliveTimeUnit() {
        Lock lock = this.lock;
        lock.lock();
        try {
            TimeUnit timeUnit = this.keepAliveTimeUnit;
            return timeUnit;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeepAliveTime(long keepAliveTime, TimeUnit keepAliveTimeUnit) {
        if (keepAliveTimeUnit == null) {
            throw new NullPointerException("keepAliveTimeUnit is null");
        }
        if (keepAliveTime < 0L) {
            throw new IllegalArgumentException("keepAliveTime is less than zero");
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            this.keepAliveTime = keepAliveTime;
            this.keepAliveTimeUnit = keepAliveTimeUnit;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RejectionPolicy getRejectionPolicy() {
        Lock lock = this.lock;
        lock.lock();
        try {
            RejectionPolicy rejectionPolicy = this.rejectionPolicy;
            return rejectionPolicy;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRejectionPolicy(RejectionPolicy newPolicy, Executor handoffExecutor) {
        if (newPolicy == null) {
            throw new NullPointerException("rejectionPolicy is null");
        }
        if (newPolicy == RejectionPolicy.HANDOFF && handoffExecutor == null) {
            throw new NullPointerException("handoffExecutor is null");
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            if (this.rejectionPolicy == RejectionPolicy.BLOCK && newPolicy != RejectionPolicy.BLOCK) {
                this.removeCondition.signalAll();
            }
            this.rejectionPolicy = newPolicy;
            this.handoffExecutor = handoffExecutor;
        }
        finally {
            lock.unlock();
        }
    }

    public void stop() {
        this.shutdown();
        try {
            this.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void destroy() {
        this.shutdownNow();
        try {
            this.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void startNewThread(Runnable task) {
        Thread thread = this.threadFactory.newThread(new Worker(task));
        this.workers.add(thread);
        thread.start();
    }

    private Runnable pollTask() {
        Runnable task = this.queue.poll();
        if (task != null) {
            this.removeCondition.signal();
            return task;
        }
        if (--this.threadCount == 0) {
            this.threadExitCondition.signalAll();
        }
        return null;
    }

    private Runnable takeTask() {
        Condition removeCondition = this.removeCondition;
        Runnable task = this.queue.poll();
        if (task != null) {
            removeCondition.signal();
            return task;
        }
        Condition enqueueCondition = this.enqueueCondition;
        long start = System.currentTimeMillis();
        boolean intr = Thread.interrupted();
        try {
            long elapsed = 0L;
            while (true) {
                Runnable runnable;
                int threadCount = this.threadCount;
                int coreThreadLimit = this.coreThreadLimit;
                boolean allowCoreThreadTimeout = this.allowCoreThreadTimeout;
                if (this.stop || threadCount > this.maxThreadLimit) {
                    runnable = this.pollTask();
                    return runnable;
                }
                if (!allowCoreThreadTimeout && threadCount < coreThreadLimit) {
                    try {
                        enqueueCondition.await();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                } else {
                    long time = this.keepAliveTime;
                    TimeUnit timeUnit = this.keepAliveTimeUnit;
                    long remaining = time - timeUnit.convert(elapsed, TimeUnit.MILLISECONDS);
                    if (remaining <= 0L && (allowCoreThreadTimeout || threadCount > coreThreadLimit)) {
                        Runnable runnable2 = this.pollTask();
                        return runnable2;
                    }
                    try {
                        enqueueCondition.await(remaining, timeUnit);
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
                task = this.queue.poll();
                if (task != null) {
                    removeCondition.signal();
                    runnable = task;
                    return runnable;
                }
                elapsed = System.currentTimeMillis() - start;
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class Worker
    implements Runnable {
        private Runnable first;

        public Worker(Runnable command) {
            this.first = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Lock lock = SimpleQueueExecutor.this.lock;
            Runnable task = this.first;
            this.first = null;
            lock.lock();
            try {
                do {
                    if (task == null) continue;
                    try {
                        if (SimpleQueueExecutor.this.interrupt) {
                            Thread.currentThread().interrupt();
                        }
                        lock.unlock();
                        try {
                            task.run();
                        }
                        finally {
                            lock.lock();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    task = null;
                } while (!(SimpleQueueExecutor.this.stop ? (task = SimpleQueueExecutor.this.pollTask()) == null : (task = SimpleQueueExecutor.this.takeTask()) == null));
                return;
            }
            finally {
                SimpleQueueExecutor.this.workers.remove(Thread.currentThread());
                lock.unlock();
            }
        }
    }
}

