/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.jboss.threads.DirectExecutor;
import org.jboss.threads.DirectExecutorService;
import org.jboss.threads.ProtectedDirectExecutorService;
import org.jboss.threads.ProtectedExecutorService;

public final class JBossExecutors {
    private static final DirectExecutor DIRECT_EXECUTOR = new DirectExecutor(){

        public void execute(Runnable command) {
            command.run();
        }
    };
    private static final DirectExecutor REJECTING_EXECUTOR = new DirectExecutor(){

        public void execute(Runnable command) {
            throw new RejectedExecutionException();
        }
    };
    private static final DirectExecutor DISCARDING_EXECUTOR = new DirectExecutor(){

        public void execute(Runnable command) {
        }
    };
    private static final DirectExecutorService DIRECT_EXECUTOR_SERVICE = new ProtectedDirectExecutorService(DIRECT_EXECUTOR);
    private static final DirectExecutorService REJECTING_EXECUTOR_SERVICE = new ProtectedDirectExecutorService(REJECTING_EXECUTOR);
    private static final DirectExecutorService DISCARDING_EXECUTOR_SERVICE = new ProtectedDirectExecutorService(DISCARDING_EXECUTOR);
    private static final RejectedExecutionHandler ABORT_POLICY = new ThreadPoolExecutor.AbortPolicy();
    private static final RejectedExecutionHandler CALLER_RUNS_POLICY = new ThreadPoolExecutor.CallerRunsPolicy();
    private static final RejectedExecutionHandler DISCARD_OLDEST_POLICY = new ThreadPoolExecutor.DiscardOldestPolicy();
    private static final RejectedExecutionHandler DISCARD_POLICY = new ThreadPoolExecutor.DiscardPolicy();

    private JBossExecutors() {
    }

    public static DirectExecutor directExecutor() {
        return DIRECT_EXECUTOR;
    }

    public static DirectExecutorService directExecutorService() {
        return DIRECT_EXECUTOR_SERVICE;
    }

    public static DirectExecutor rejectingExecutor() {
        return REJECTING_EXECUTOR;
    }

    public static DirectExecutorService rejectingExecutorService() {
        return REJECTING_EXECUTOR_SERVICE;
    }

    public static DirectExecutor discardingExecutor() {
        return DISCARDING_EXECUTOR;
    }

    public static DirectExecutorService discardingExecutorService() {
        return DISCARDING_EXECUTOR_SERVICE;
    }

    public static Runnable executorTask(final DirectExecutor executor, final Runnable task) {
        return new Runnable(){

            public void run() {
                executor.execute(task);
            }
        };
    }

    public static Executor wrappingExecutor(final Executor delegate, final DirectExecutor taskWrapper) {
        return new Executor(){

            public void execute(Runnable command) {
                delegate.execute(JBossExecutors.executorTask(taskWrapper, command));
            }
        };
    }

    public static DirectExecutor privilegedExecutor(final DirectExecutor delegate, final AccessControlContext context) {
        return new DirectExecutor(){

            public void execute(final Runnable command) {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            delegate.execute(command);
                            return null;
                        }
                    }, context);
                } else {
                    delegate.execute(command);
                }
            }
        };
    }

    public static DirectExecutor contextClassLoaderExecutor(final DirectExecutor delegate, final ClassLoader taskClassLoader) {
        return new DirectExecutor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Runnable command) {
                Thread thr = Thread.currentThread();
                ClassLoader old = thr.getContextClassLoader();
                thr.setContextClassLoader(taskClassLoader);
                try {
                    delegate.execute(command);
                }
                finally {
                    thr.setContextClassLoader(old);
                }
            }
        };
    }

    public static DirectExecutor threadNameExecutor(final DirectExecutor delegate, final String newName) {
        return new DirectExecutor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Runnable command) {
                Thread thr = Thread.currentThread();
                String oldName = thr.getName();
                thr.setName(newName);
                try {
                    delegate.execute(command);
                }
                finally {
                    thr.setName(oldName);
                }
            }
        };
    }

    public static DirectExecutor threadNameNotateExecutor(final DirectExecutor delegate, final String notation) {
        return new DirectExecutor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Runnable command) {
                Thread thr = Thread.currentThread();
                String oldName = thr.getName();
                thr.setName(oldName + " (" + notation + ')');
                try {
                    delegate.execute(command);
                }
                finally {
                    thr.setName(oldName);
                }
            }
        };
    }

    public static DirectExecutor exceptionLoggingExecutor(final DirectExecutor delegate, Object log) {
        return new DirectExecutor(){

            public void execute(Runnable command) {
                try {
                    delegate.execute(command);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
    }

    public static Executor threadFactoryExecutor(final ThreadFactory factory) {
        return new Executor(){

            public void execute(Runnable command) {
                factory.newThread(command).start();
            }
        };
    }

    public static RejectedExecutionHandler abortPolicy() {
        return ABORT_POLICY;
    }

    public static RejectedExecutionHandler callerRunsPolicy() {
        return CALLER_RUNS_POLICY;
    }

    public static RejectedExecutionHandler discardOldestPolicy() {
        return DISCARD_OLDEST_POLICY;
    }

    public static RejectedExecutionHandler discardPolicy() {
        return DISCARD_POLICY;
    }

    public static RejectedExecutionHandler handoffPolicy(final Executor target) {
        return new RejectedExecutionHandler(){

            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                target.execute(r);
            }
        };
    }

    public static ExecutorService protectedExecutorService(Executor target) {
        return new ProtectedExecutorService(target);
    }

    public static DirectExecutorService protectedDirectExecutorService(DirectExecutor target) {
        return new ProtectedDirectExecutorService(target);
    }
}

