/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.audit.report;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.test.audit.config.RuntimeProperties;
import org.jboss.test.audit.generate.SectionIdGenerator;
import org.jboss.test.audit.report.AssertionGroup;
import org.jboss.test.audit.report.AuditAssertion;
import org.jboss.test.audit.report.SectionIdComparator;
import org.jboss.test.audit.report.SectionItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuditParser {
    private SectionIdGenerator sectionIdGenerator;
    private String name;
    private String specId;
    private String version;
    private Map<String, List<SectionItem>> sectionItems = new HashMap<String, List<SectionItem>>();
    private Map<String, String> titles = new HashMap<String, String>();
    private Map<String, String> generatedToOriginalIdMap = new HashMap<String, String>();
    private Map<String, String> originalToGeneratedIdMap = new HashMap<String, String>();
    private InputStream source;

    public AuditParser(InputStream source, RuntimeProperties properties) {
        this.source = source;
    }

    public String getName() {
        return this.name;
    }

    public String getSpecId() {
        return this.specId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSectionTitle(String sectionId) {
        return this.titles.get(sectionId);
    }

    public Map<String, List<SectionItem>> getSectionItems() {
        return this.sectionItems;
    }

    public List<String> getSectionIds() {
        ArrayList<String> sectionIds = new ArrayList<String>(this.sectionItems.keySet());
        Collections.sort(sectionIds, new SectionIdComparator());
        return sectionIds;
    }

    public List<AuditAssertion> getAssertionsForSection(String sectionId) {
        ArrayList<AuditAssertion> assertions = new ArrayList<AuditAssertion>();
        for (SectionItem item : this.sectionItems.get(sectionId)) {
            if (item instanceof AuditAssertion) {
                assertions.add((AuditAssertion)item);
                continue;
            }
            if (!(item instanceof AssertionGroup)) continue;
            for (AuditAssertion assertion : ((AssertionGroup)item).getAssertions()) {
                assertions.add(assertion);
            }
        }
        return assertions;
    }

    public List<SectionItem> getItemsForSection(String sectionId) {
        ArrayList<SectionItem> items = new ArrayList<SectionItem>((Collection)this.sectionItems.get(sectionId));
        return items;
    }

    public boolean hasAssertion(String sectionId, String assertionId) {
        if (this.sectionIdGenerator != null) {
            sectionId = this.originalToGeneratedIdMap.get(sectionId);
        }
        if (!this.sectionItems.containsKey(sectionId)) {
            return false;
        }
        for (SectionItem item : this.sectionItems.get(sectionId)) {
            if (item instanceof AuditAssertion && ((AuditAssertion)item).getId().equals(assertionId)) {
                return true;
            }
            if (!(item instanceof AssertionGroup)) continue;
            for (AuditAssertion assertion : ((AssertionGroup)item).getAssertions()) {
                if (!assertion.getId().equals(assertionId)) continue;
                return true;
            }
        }
        return false;
    }

    public AuditParser parse() throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(this.source);
        NodeList sectionNodes = doc.getDocumentElement().getChildNodes();
        this.name = doc.getDocumentElement().getAttribute("name");
        this.specId = doc.getDocumentElement().getAttribute("id");
        this.version = doc.getDocumentElement().getAttribute("version");
        if (Boolean.parseBoolean(doc.getDocumentElement().getAttribute("generateSectionIds"))) {
            this.sectionIdGenerator = new SectionIdGenerator();
        }
        for (int i = 0; i < sectionNodes.getLength(); ++i) {
            if (!(sectionNodes.item(i) instanceof Element) || !"section".equals(sectionNodes.item(i).getNodeName())) continue;
            this.processSectionNode((Element)sectionNodes.item(i));
        }
        return this;
    }

    public String getSectionOriginalId(String sectionId) {
        return this.generatedToOriginalIdMap.get(sectionId);
    }

    public boolean hasSectionIdsGenerated() {
        return this.sectionIdGenerator != null;
    }

    private void processSectionNode(Element node) {
        String id = node.getAttribute("id");
        String level = node.getAttribute("level");
        if (this.hasSectionIdsGenerated() && level.isEmpty()) {
            throw new IllegalStateException("Section id generation is enabled and node is missing a level info");
        }
        String sectionId = this.sectionIdGenerator != null ? this.sectionIdGenerator.nextId(Integer.valueOf(level)) : id;
        this.titles.put(sectionId, node.getAttribute("title"));
        this.sectionItems.put(sectionId, new ArrayList());
        if (this.sectionIdGenerator != null) {
            this.generatedToOriginalIdMap.put(sectionId, id);
            this.originalToGeneratedIdMap.put(id, sectionId);
        }
        NodeList assertionNodes = node.getChildNodes();
        for (int i = 0; i < assertionNodes.getLength(); ++i) {
            if (assertionNodes.item(i) instanceof Element && "assertion".equals(assertionNodes.item(i).getNodeName())) {
                this.processAssertionNode(sectionId, (Element)assertionNodes.item(i), null);
                continue;
            }
            if (!(assertionNodes.item(i) instanceof Element) || !"group".equals(assertionNodes.item(i).getNodeName())) continue;
            this.processGroupNode(sectionId, (Element)assertionNodes.item(i));
        }
    }

    private void processGroupNode(String sectionId, Element node) {
        AssertionGroup group = new AssertionGroup(sectionId);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child instanceof Element && "assertion".equals(child.getNodeName())) {
                this.processAssertionNode(sectionId, (Element)child, group);
                continue;
            }
            if (!(child instanceof Element) || !"text".equals(child.getNodeName())) continue;
            group.setText(child.getTextContent());
        }
        List<SectionItem> items = this.sectionItems.get(sectionId);
        items.add(group);
    }

    private void processAssertionNode(String sectionId, Element node, AssertionGroup group) {
        String text = null;
        String note = null;
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node child = node.getChildNodes().item(i);
            if (!(child instanceof Element)) continue;
            if ("text".equals(child.getNodeName())) {
                text = child.getTextContent();
                continue;
            }
            if (!"note".equals(child.getNodeName())) continue;
            note = child.getTextContent();
        }
        boolean testable = node.hasAttribute("testable") ? Boolean.parseBoolean(node.getAttribute("testable")) : true;
        boolean implied = node.hasAttribute("implied") ? Boolean.parseBoolean(node.getAttribute("implied")) : false;
        AuditAssertion assertion = new AuditAssertion(sectionId, node.getAttribute("id"), text, note, testable, implied, group);
        if (assertion.getGroup() != null) {
            group.addAssertion(assertion);
        } else {
            List<SectionItem> items = this.sectionItems.get(sectionId);
            items.add(assertion);
        }
    }
}

