/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.Assertion;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.RelationalNodeStatistics;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.util.CommandContext;

public abstract class RelationalNode
implements Cloneable,
BatchCollector.BatchProducer {
    private ProcessingState processingState;
    private NodeData data;
    private RelationalNode parent;
    private RelationalNode[] children = new RelationalNode[2];
    protected int childCount;
    private static final String TAB = "  ";

    protected RelationalNode() {
    }

    public RelationalNode(int nodeID) {
        this.data = new NodeData();
        this.data.nodeID = nodeID;
    }

    public int getChildCount() {
        return this.childCount;
    }

    public boolean isLastBatch() {
        return this.getProcessingState().lastBatch;
    }

    public void setContext(CommandContext context) {
        this.getProcessingState().context = context;
    }

    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        this.getProcessingState().context = context;
        this.getProcessingState().bufferManager = bufferManager;
        this.getProcessingState().dataMgr = dataMgr;
        if (context.getCollectNodeStatistics()) {
            this.getProcessingState().nodeStatistics = new RelationalNodeStatistics();
        }
        this.getProcessingState().batchSize = this.getOutputElements() != null ? bufferManager.getProcessorBatchSize(this.getOutputElements()) : bufferManager.getProcessorBatchSize();
    }

    public CommandContext getContext() {
        return this.getProcessingState().context;
    }

    public int getID() {
        return this.data.nodeID;
    }

    public void setID(int nodeID) {
        NodeData newData = new NodeData();
        newData.nodeID = nodeID;
        newData.elements = this.data.elements;
        this.data = newData;
    }

    protected BufferManager getBufferManager() {
        return this.getProcessingState().bufferManager;
    }

    protected ProcessorDataManager getDataManager() {
        return this.getProcessingState().dataMgr;
    }

    protected String getConnectionID() {
        return this.getProcessingState().context.getConnectionId();
    }

    protected int getBatchSize() {
        return this.getProcessingState().batchSize;
    }

    public void reset() {
        for (int i = 0; i < this.children.length && this.children[i] != null; ++i) {
            this.children[i].reset();
        }
        if (this.getProcessingState() != null) {
            this.getProcessingState().reset();
        }
    }

    public void setElements(List<? extends Expression> elements) {
        this.data.elements = elements;
    }

    @Override
    public List<? extends Expression> getOutputElements() {
        return this.getElements();
    }

    public List<? extends Expression> getElements() {
        return this.data.elements;
    }

    public RelationalNode getParent() {
        return this.parent;
    }

    public void setParent(RelationalNode parent) {
        this.parent = parent;
    }

    public RelationalNode[] getChildren() {
        return this.children;
    }

    public void addChild(RelationalNode child) {
        child.setParent(this);
        if (this.children.length == this.childCount) {
            RelationalNode[] newChildren = new RelationalNode[this.children.length * 2];
            System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
            this.children = newChildren;
        }
        this.children[this.childCount++] = child;
    }

    protected void addBatchRow(List<?> row) {
        if (this.getProcessingState().batchRows == null) {
            this.getProcessingState().batchRows = new ArrayList(this.getProcessingState().batchSize / 4);
        }
        this.getProcessingState().batchRows.add(row);
    }

    protected void terminateBatches() {
        this.getProcessingState().lastBatch = true;
    }

    protected boolean isBatchFull() {
        return this.getProcessingState().batchRows != null && this.getProcessingState().batchRows.size() >= this.getProcessingState().batchSize;
    }

    protected boolean hasPendingRows() {
        return this.getProcessingState().batchRows != null;
    }

    protected TupleBatch pullBatch() {
        TupleBatch batch = null;
        if (this.getProcessingState().batchRows != null) {
            batch = new TupleBatch((long)this.getProcessingState().beginBatch, this.getProcessingState().batchRows);
            this.getProcessingState().beginBatch += this.getProcessingState().batchRows.size();
        } else {
            batch = new TupleBatch((long)this.getProcessingState().beginBatch, Collections.EMPTY_LIST);
        }
        batch.setTerminationFlag(this.getProcessingState().lastBatch);
        this.getProcessingState().batchRows = null;
        this.getProcessingState().lastBatch = false;
        return batch;
    }

    public void open() throws TeiidComponentException, TeiidProcessingException {
        for (int i = 0; i < this.children.length && this.children[i] != null; ++i) {
            this.children[i].open();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        CommandContext context = this.getContext();
        if (context != null && context.isCancelled()) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30160, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30160, new Object[]{this.getContext().getRequestId()}));
        }
        boolean recordStats = context != null && context.getCollectNodeStatistics();
        try {
            while (true) {
                if (recordStats) {
                    this.getProcessingState().nodeStatistics.startBatchTimer();
                }
                TupleBatch batch = this.nextBatchDirect();
                if (recordStats) {
                    this.getProcessingState().nodeStatistics.stopBatchTimer();
                    this.getProcessingState().nodeStatistics.collectCumulativeNodeStats(Long.valueOf(batch.getRowCount()), 0);
                    if (batch.getTerminationFlag()) {
                        this.getProcessingState().nodeStatistics.collectNodeStats(this.getChildren());
                    }
                    this.recordBatch(batch);
                    recordStats = false;
                }
                if (batch.getRowCount() != 0 || batch.getTerminationFlag()) {
                    if (batch.getTerminationFlag()) {
                        this.close();
                    }
                    TupleBatch tupleBatch = batch;
                    return tupleBatch;
                }
                continue;
                break;
            }
        }
        catch (BlockedException e) {
            if (!recordStats) throw e;
            this.getProcessingState().nodeStatistics.stopBatchTimer();
            this.getProcessingState().nodeStatistics.collectCumulativeNodeStats(null, 1);
            recordStats = false;
            throw e;
        }
        finally {
            if (recordStats) {
                this.getProcessingState().nodeStatistics.stopBatchTimer();
            }
        }
    }

    protected abstract TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException;

    @Override
    public final void close() throws TeiidComponentException {
        if (!this.getProcessingState().closed) {
            this.closeDirect();
            for (int i = 0; i < this.children.length && this.children[i] != null; ++i) {
                this.children[i].close();
            }
            this.getProcessingState().closed = true;
        }
    }

    public void closeDirect() {
    }

    public boolean isClosed() {
        return this.getProcessingState().closed;
    }

    public static int[] getProjectionIndexes(Map<? extends Expression, Integer> tupleElements, List<? extends Expression> projectElements) {
        int[] result = new int[projectElements.size()];
        int i = 0;
        for (Expression expression : projectElements) {
            Integer index = tupleElements.get(expression);
            Assertion.isNotNull((Object)index);
            result[i++] = index;
        }
        return result;
    }

    public static <T> List<T> projectTuple(int[] indexes, List<T> tupleValues) {
        return RelationalNode.projectTuple(indexes, tupleValues, false);
    }

    public static <T> List<T> projectTuple(int[] indexes, List<T> tupleValues, boolean omitMissing) {
        ArrayList<T> projectedTuple = new ArrayList<T>(indexes.length);
        for (int index : indexes) {
            if (omitMissing && index == -1) {
                projectedTuple.add(null);
                continue;
            }
            projectedTuple.add(tupleValues.get(index));
        }
        return projectedTuple;
    }

    public static Map<Expression, Integer> createLookupMap(List<? extends Expression> elements) {
        HashMap<Expression, Integer> lookupMap = new HashMap<Expression, Integer>();
        for (int i = 0; i < elements.size(); ++i) {
            Expression element = elements.get(i);
            lookupMap.put(element, i);
            if (!(element instanceof AliasSymbol)) continue;
            lookupMap.put(((AliasSymbol)element).getSymbol(), i);
        }
        return lookupMap;
    }

    private void recordBatch(TupleBatch batch) {
        if (!LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)6)) {
            return;
        }
        StringBuffer str = new StringBuffer();
        str.append(this.getClassName());
        str.append("(");
        str.append(this.getID());
        str.append(") sending ");
        str.append(batch);
        str.append("\n");
        for (long row = batch.getBeginRow(); row <= batch.getEndRow(); ++row) {
            str.append("\t").append(row).append(": ").append(batch.getTuple(row)).append("\n");
        }
        LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object)str.toString());
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        this.getRecursiveString(str, 0);
        return str.toString();
    }

    public String nodeToString() {
        StringBuffer str = new StringBuffer();
        this.getNodeString(str);
        return str.toString();
    }

    private void setTab(StringBuffer str, int tabStop) {
        for (int i = 0; i < tabStop; ++i) {
            str.append(TAB);
        }
    }

    private void getRecursiveString(StringBuffer str, int tabLevel) {
        this.setTab(str, tabLevel);
        this.getNodeString(str);
        str.append("\n");
        for (int i = 0; i < this.children.length && this.children[i] != null; ++i) {
            this.children[i].getRecursiveString(str, tabLevel + 1);
        }
    }

    protected void getNodeString(StringBuffer str) {
        str.append(this.getClassName());
        str.append("(");
        str.append(this.getID());
        str.append(") output=");
        str.append(this.getElements());
        str.append(" ");
    }

    protected String getClassName() {
        return this.getClass().getSimpleName();
    }

    public abstract Object clone();

    protected void copyTo(RelationalNode target) {
        target.data = this.data;
        target.children = new RelationalNode[this.children.length];
        for (int i = 0; i < this.children.length && this.children[i] != null; ++i) {
            target.children[i] = (RelationalNode)this.children[i].clone();
            target.children[i].setParent(target);
        }
        target.childCount = this.childCount;
    }

    public PlanNode getDescriptionProperties() {
        List<String> costEstimates;
        PlanNode result = new PlanNode(this.getClassName());
        result.addProperty("Relational Node ID", String.valueOf(this.getID()));
        result.addProperty("Output Columns", AnalysisRecord.getOutputColumnProperties(this.data.elements));
        if (this.getProcessingState().context != null && this.getProcessingState().context.getCollectNodeStatistics()) {
            result.addProperty("Statistics", this.getProcessingState().nodeStatistics.getStatisticsList());
        }
        if ((costEstimates = this.getCostEstimates()) != null) {
            result.addProperty("Cost Estimates", costEstimates);
        }
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] == null) continue;
            result.addProperty("Child " + i, this.children[i].getDescriptionProperties());
        }
        return result;
    }

    public RelationalNodeStatistics getNodeStatistics() {
        return this.getProcessingState().nodeStatistics;
    }

    public void setEstimateNodeCardinality(Number estimateNodeCardinality) {
        this.data.estimateNodeCardinality = estimateNodeCardinality;
    }

    public void setEstimateNodeSetSize(Number setSizeEstimate) {
        this.data.setSizeEstimate = setSizeEstimate;
    }

    public void setEstimateDepAccessCardinality(Number depAccessEstimate) {
        this.data.depAccessEstimate = depAccessEstimate;
    }

    public void setEstimateDepJoinCost(Number estimateDepJoinCost) {
        this.data.estimateDepJoinCost = estimateDepJoinCost;
    }

    public void setEstimateJoinCost(Number estimateJoinCost) {
        this.data.estimateJoinCost = estimateJoinCost;
    }

    private List<String> getCostEstimates() {
        ArrayList<String> costEstimates = new ArrayList<String>();
        if (this.data.estimateNodeCardinality != null) {
            costEstimates.add("Estimated Node Cardinality: " + this.data.estimateNodeCardinality);
        }
        if (this.data.setSizeEstimate != null) {
            costEstimates.add("Estimated Independent Node Produced Set Size: " + this.data.setSizeEstimate);
        }
        if (this.data.depAccessEstimate != null) {
            costEstimates.add("Estimated Dependent Access Cardinality: " + this.data.depAccessEstimate);
        }
        if (this.data.estimateDepJoinCost != null) {
            costEstimates.add("Estimated Dependent Join Cost: " + this.data.estimateDepJoinCost);
        }
        if (this.data.estimateJoinCost != null) {
            costEstimates.add("Estimated Join Cost: " + this.data.estimateJoinCost);
        }
        if (costEstimates.size() <= 0) {
            return null;
        }
        return costEstimates;
    }

    public Number getEstimateNodeCardinality() {
        return this.data.estimateNodeCardinality;
    }

    private final ProcessingState getProcessingState() {
        if (this.processingState == null) {
            this.processingState = new ProcessingState();
        }
        return this.processingState;
    }

    @Override
    public boolean hasBuffer() {
        return false;
    }

    @Override
    public final TupleBuffer getBuffer(int maxRows) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        CommandContext context = this.getContext();
        if (context != null && context.isCancelled()) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30160, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30160, new Object[]{this.getContext().getRequestId()}));
        }
        boolean recordStats = context != null && context.getCollectNodeStatistics() && !this.isLastBatch();
        try {
            if (recordStats) {
                this.getProcessingState().nodeStatistics.startBatchTimer();
            }
            TupleBuffer buffer = this.getBufferDirect(maxRows);
            this.terminateBatches();
            if (recordStats) {
                this.getProcessingState().nodeStatistics.stopBatchTimer();
                this.getProcessingState().nodeStatistics.collectCumulativeNodeStats(buffer.getRowCount(), 0);
                this.getProcessingState().nodeStatistics.collectNodeStats(this.getChildren());
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)6) && !buffer.isForwardOnly()) {
                    for (long i = 1L; i <= buffer.getRowCount(); i += (long)buffer.getBatchSize()) {
                        TupleBatch tb = buffer.getBatch(i);
                        this.recordBatch(tb);
                    }
                }
                recordStats = false;
            }
            TupleBuffer tupleBuffer = buffer;
            return tupleBuffer;
        }
        catch (BlockedException e) {
            if (recordStats) {
                this.getProcessingState().nodeStatistics.stopBatchTimer();
                this.getProcessingState().nodeStatistics.collectCumulativeNodeStats(null, 1);
                recordStats = false;
            }
            throw e;
        }
        finally {
            if (recordStats) {
                this.getProcessingState().nodeStatistics.stopBatchTimer();
            }
        }
    }

    protected TupleBuffer getBufferDirect(int maxRows) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        return null;
    }

    public static void unwrapException(TeiidRuntimeException e) throws TeiidComponentException, TeiidProcessingException {
        if (e == null) {
            return;
        }
        if (e.getCause() instanceof TeiidComponentException) {
            throw (TeiidComponentException)e.getCause();
        }
        if (e.getCause() instanceof TeiidProcessingException) {
            throw (TeiidProcessingException)e.getCause();
        }
        throw e;
    }

    public Boolean requiresTransaction(boolean transactionalReads) {
        return false;
    }

    static class ProcessingState {
        CommandContext context;
        BufferManager bufferManager;
        ProcessorDataManager dataMgr;
        int batchSize;
        RelationalNodeStatistics nodeStatistics;
        int beginBatch = 1;
        List batchRows;
        boolean lastBatch;
        boolean closed;

        ProcessingState() {
        }

        void reset() {
            this.beginBatch = 1;
            this.batchRows = null;
            this.lastBatch = false;
            this.closed = false;
        }
    }

    static class NodeData {
        int nodeID;
        List<? extends Expression> elements;
        Number estimateNodeCardinality;
        Number setSizeEstimate;
        Number depAccessEstimate;
        Number estimateDepJoinCost;
        Number estimateJoinCost;

        NodeData() {
        }
    }
}

