/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class CreateProcedureCommand
extends Command {
    private Block block;
    private Command userCommand;
    private List projectedSymbols;
    private GroupSymbol virtualGroup;
    private Command resultsCommand;

    public CreateProcedureCommand() {
    }

    public CreateProcedureCommand(Block block) {
        this.block = block;
    }

    @Override
    public int getType() {
        return 7;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block block) {
        this.block = block;
    }

    public void setUserCommand(Command command) {
        this.userCommand = command;
    }

    public Command getUserCommand() {
        return this.userCommand;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        CreateProcedureCommand copy = new CreateProcedureCommand();
        if (this.block != null) {
            copy.setBlock(this.block.clone());
        }
        if (this.projectedSymbols != null) {
            copy.setProjectedSymbols(new ArrayList(this.projectedSymbols));
        }
        if (this.virtualGroup != null) {
            copy.virtualGroup = this.virtualGroup.clone();
        }
        this.copyMetadataState(copy);
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CreateProcedureCommand)) {
            return false;
        }
        CreateProcedureCommand other = (CreateProcedureCommand)obj;
        return this.sameOptionAndHint(other) && EquivalenceUtil.areEqual((Object)this.getBlock(), (Object)other.getBlock());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.getBlock()});
        return myHash;
    }

    @Override
    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public List getProjectedSymbols() {
        StoredProcedure sp;
        if (this.projectedSymbols != null) {
            return this.projectedSymbols;
        }
        if (this.resultsCommand == null) {
            return Collections.EMPTY_LIST;
        }
        List<Expression> symbols = this.resultsCommand.getProjectedSymbols();
        if (this.resultsCommand instanceof StoredProcedure && (sp = (StoredProcedure)this.resultsCommand).isCallableStatement()) {
            symbols = sp.getResultSetColumns();
        }
        this.setProjectedSymbols(symbols);
        return this.projectedSymbols;
    }

    public void setProjectedSymbols(List projSymbols) {
        this.projectedSymbols = projSymbols;
    }

    public Command getResultsCommand() {
        return this.resultsCommand;
    }

    public void setResultsCommand(Command command) {
        this.resultsCommand = command;
    }

    @Override
    public boolean areResultsCachable() {
        return Query.areColumnsCachable(this.getProjectedSymbols());
    }

    public GroupSymbol getVirtualGroup() {
        return this.virtualGroup;
    }

    public void setVirtualGroup(GroupSymbol virtualGroup) {
        this.virtualGroup = virtualGroup;
    }
}

