/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.id.IDGenerator;
import org.teiid.core.util.Assertion;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.AliasGenerator;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleAssignOutputElements;
import org.teiid.query.optimizer.relational.rules.RuleChooseJoinStrategy;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.RegisterRequestParameter;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.ArrayTableNode;
import org.teiid.query.processor.relational.DependentAccessNode;
import org.teiid.query.processor.relational.DependentProcedureAccessNode;
import org.teiid.query.processor.relational.DependentProcedureExecutionNode;
import org.teiid.query.processor.relational.EnhancedSortMergeJoinStrategy;
import org.teiid.query.processor.relational.GroupingNode;
import org.teiid.query.processor.relational.InsertPlanExecutionNode;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.LimitNode;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.NestedLoopJoinStrategy;
import org.teiid.query.processor.relational.NestedTableJoinStrategy;
import org.teiid.query.processor.relational.NullNode;
import org.teiid.query.processor.relational.PlanExecutionNode;
import org.teiid.query.processor.relational.ProjectIntoNode;
import org.teiid.query.processor.relational.ProjectNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.processor.relational.SelectNode;
import org.teiid.query.processor.relational.SortNode;
import org.teiid.query.processor.relational.SortUtility;
import org.teiid.query.processor.relational.TextTableNode;
import org.teiid.query.processor.relational.UnionAllNode;
import org.teiid.query.processor.relational.WindowFunctionProjectNode;
import org.teiid.query.processor.relational.XMLTableNode;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.ArrayTable;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.lang.TextTable;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.WindowFunction;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;

public class PlanToProcessConverter {
    protected QueryMetadataInterface metadata;
    private IDGenerator idGenerator;
    private AnalysisRecord analysisRecord;
    private CapabilitiesFinder capFinder;
    private Map<Command, AccessNode> sharedCommands = new HashMap<Command, AccessNode>();
    private static AtomicInteger sharedId = new AtomicInteger();

    public PlanToProcessConverter(QueryMetadataInterface metadata, IDGenerator idGenerator, AnalysisRecord analysisRecord, CapabilitiesFinder capFinder) {
        this.metadata = metadata;
        this.idGenerator = idGenerator;
        this.analysisRecord = analysisRecord;
        this.capFinder = capFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationalPlan convert(PlanNode planNode) throws QueryPlannerException, TeiidComponentException {
        try {
            RelationalPlan processPlan;
            boolean debug = this.analysisRecord.recordDebug();
            if (debug) {
                this.analysisRecord.println("\n============================================================================");
                this.analysisRecord.println("CONVERTING PLAN TREE TO PROCESS TREE");
            }
            RelationalNode processNode = this.convertPlan(planNode);
            if (debug) {
                this.analysisRecord.println("\nPROCESS PLAN = \n" + processNode);
                this.analysisRecord.println("============================================================================");
            }
            RelationalPlan relationalPlan = processPlan = new RelationalPlan(processNode);
            return relationalPlan;
        }
        finally {
            this.sharedCommands.clear();
        }
    }

    private RelationalNode convertPlan(PlanNode planNode) throws QueryPlannerException, TeiidComponentException {
        RelationalNode convertedNode = this.convertNode(planNode);
        if (convertedNode == null) {
            Assertion.assertTrue((planNode.getChildCount() == 1 ? 1 : 0) != 0);
            return this.convertPlan(planNode.getFirstChild());
        }
        RelationalNode nextParent = convertedNode;
        while (nextParent.getChildren()[0] != null) {
            nextParent = nextParent.getChildren()[0];
        }
        for (PlanNode childNode : planNode.getChildren()) {
            RelationalNode child = this.convertPlan(childNode);
            if (planNode.getType() == 256 && childNode.getType() == 256 && childNode.hasBooleanProperty(NodeConstants.Info.USE_ALL)) {
                for (RelationalNode grandChild : child.getChildren()) {
                    if (grandChild == null) continue;
                    nextParent.addChild(grandChild);
                }
                continue;
            }
            nextParent.addChild(child);
        }
        return convertedNode;
    }

    protected int getID() {
        return this.idGenerator.nextInt();
    }

    protected RelationalNode convertNode(PlanNode node) throws QueryPlannerException, TeiidComponentException {
        RelationalNode processNode = null;
        switch (node.getType()) {
            case 8: {
                GroupSymbol intoGroup = (GroupSymbol)node.getProperty(NodeConstants.Info.INTO_GROUP);
                if (intoGroup != null) {
                    try {
                        Insert insert = (Insert)node.getFirstChild().getProperty(NodeConstants.Info.VIRTUAL_COMMAND);
                        List<ElementSymbol> allIntoElements = insert.getVariables();
                        Object groupID = intoGroup.getMetadataID();
                        Object modelID = this.metadata.getModelID(groupID);
                        String modelName = this.metadata.getFullName(modelID);
                        if (this.metadata.isVirtualGroup(groupID)) {
                            InsertPlanExecutionNode ipen = new InsertPlanExecutionNode(this.getID(), this.metadata);
                            ipen.setProcessorPlan((ProcessorPlan)node.getFirstChild().getProperty(NodeConstants.Info.PROCESSOR_PLAN));
                            ipen.setReferences(insert.getValues());
                            processNode = ipen;
                            break;
                        }
                        ProjectIntoNode pinode = new ProjectIntoNode(this.getID());
                        pinode.setIntoGroup(intoGroup);
                        pinode.setIntoElements(allIntoElements);
                        pinode.setModelName(modelName);
                        processNode = pinode;
                        SourceCapabilities caps = this.capFinder.findCapabilities(modelName);
                        if (caps.supportsCapability(SourceCapabilities.Capability.INSERT_WITH_ITERATOR)) {
                            pinode.setMode(ProjectIntoNode.Mode.ITERATOR);
                            break;
                        }
                        if (caps.supportsCapability(SourceCapabilities.Capability.BATCHED_UPDATES)) {
                            pinode.setMode(ProjectIntoNode.Mode.BATCH);
                            break;
                        }
                        pinode.setMode(ProjectIntoNode.Mode.SINGLE);
                        break;
                    }
                    catch (QueryMetadataException e) {
                        throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30247, (Throwable)((Object)e));
                    }
                }
                List symbols = (List)node.getProperty(NodeConstants.Info.PROJECT_COLS);
                ProjectNode pnode = new ProjectNode(this.getID());
                pnode.setSelectSymbols(symbols);
                processNode = pnode;
                if (!node.hasBooleanProperty(NodeConstants.Info.HAS_WINDOW_FUNCTIONS)) break;
                WindowFunctionProjectNode wfpn = new WindowFunctionProjectNode(this.getID());
                Set<WindowFunction> windowFunctions = RuleAssignOutputElements.getWindowFunctions(symbols);
                ArrayList<WindowFunction> outputElements = new ArrayList<WindowFunction>(windowFunctions);
                for (Expression singleElementSymbol : (List)node.getFirstChild().getProperty(NodeConstants.Info.OUTPUT_COLS)) {
                    outputElements.add((WindowFunction)singleElementSymbol);
                }
                wfpn.setElements(outputElements);
                wfpn.init();
                pnode.addChild(wfpn);
                break;
            }
            case 4: {
                JoinType jtype = (JoinType)node.getProperty(NodeConstants.Info.JOIN_TYPE);
                JoinNode.JoinStrategyType stype = (JoinNode.JoinStrategyType)((Object)node.getProperty(NodeConstants.Info.JOIN_STRATEGY));
                JoinNode jnode = new JoinNode(this.getID());
                jnode.setJoinType(jtype);
                jnode.setLeftDistinct(node.hasBooleanProperty(NodeConstants.Info.IS_LEFT_DISTINCT));
                jnode.setRightDistinct(node.hasBooleanProperty(NodeConstants.Info.IS_RIGHT_DISTINCT));
                List joinCrits = (List)node.getProperty(NodeConstants.Info.JOIN_CRITERIA);
                String depValueSource = (String)node.getProperty(NodeConstants.Info.DEPENDENT_VALUE_SOURCE);
                MergeJoinStrategy.SortOption leftSort = (MergeJoinStrategy.SortOption)((Object)node.getProperty(NodeConstants.Info.SORT_LEFT));
                if (stype == JoinNode.JoinStrategyType.MERGE || stype == JoinNode.JoinStrategyType.ENHANCED_SORT) {
                    MergeJoinStrategy mjStrategy = null;
                    if (stype.equals((Object)JoinNode.JoinStrategyType.ENHANCED_SORT)) {
                        EnhancedSortMergeJoinStrategy esmjStrategy = new EnhancedSortMergeJoinStrategy(leftSort, (MergeJoinStrategy.SortOption)((Object)node.getProperty(NodeConstants.Info.SORT_RIGHT)));
                        esmjStrategy.setSemiDep(node.hasBooleanProperty(NodeConstants.Info.IS_SEMI_DEP));
                        mjStrategy = esmjStrategy;
                    } else {
                        mjStrategy = new MergeJoinStrategy(leftSort, (MergeJoinStrategy.SortOption)((Object)node.getProperty(NodeConstants.Info.SORT_RIGHT)), false);
                    }
                    jnode.setJoinStrategy(mjStrategy);
                    List leftExpressions = (List)node.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS);
                    List rightExpressions = (List)node.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS);
                    jnode.setJoinExpressions(leftExpressions, rightExpressions);
                    joinCrits = (List)node.getProperty(NodeConstants.Info.NON_EQUI_JOIN_CRITERIA);
                } else if (stype == JoinNode.JoinStrategyType.NESTED_TABLE) {
                    NestedTableJoinStrategy ntjStrategy = new NestedTableJoinStrategy();
                    jnode.setJoinStrategy(ntjStrategy);
                    SymbolMap references = (SymbolMap)FrameUtil.findJoinSourceNode(node.getFirstChild()).getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
                    ntjStrategy.setLeftMap(references);
                    references = (SymbolMap)FrameUtil.findJoinSourceNode(node.getLastChild()).getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
                    ntjStrategy.setRightMap(references);
                } else {
                    NestedLoopJoinStrategy nljStrategy = new NestedLoopJoinStrategy();
                    jnode.setJoinStrategy(nljStrategy);
                }
                Criteria joinCrit = Criteria.combineCriteria(joinCrits);
                jnode.setJoinCriteria(joinCrit);
                processNode = jnode;
                jnode.setDependentValueSource(depValueSource);
                break;
            }
            case 1: {
                ProcessorPlan plan = (ProcessorPlan)node.getProperty(NodeConstants.Info.PROCESSOR_PLAN);
                if (plan != null) {
                    PlanExecutionNode peNode = null;
                    Criteria crit = (Criteria)node.getProperty(NodeConstants.Info.PROCEDURE_CRITERIA);
                    if (crit != null) {
                        List references = (List)node.getProperty(NodeConstants.Info.PROCEDURE_INPUTS);
                        List defaults = (List)node.getProperty(NodeConstants.Info.PROCEDURE_DEFAULTS);
                        peNode = new DependentProcedureExecutionNode(this.getID(), crit, references, defaults);
                    } else {
                        peNode = new PlanExecutionNode(this.getID());
                    }
                    peNode.setProcessorPlan(plan);
                    processNode = peNode;
                    break;
                }
                AccessNode aNode = null;
                Command command = (Command)node.getProperty(NodeConstants.Info.ATOMIC_REQUEST);
                Object modelID = node.getProperty(NodeConstants.Info.MODEL_ID);
                EvaluatableVisitor ev = null;
                if (node.hasBooleanProperty(NodeConstants.Info.IS_DEPENDENT_SET)) {
                    if (command instanceof StoredProcedure) {
                        List references = (List)node.getProperty(NodeConstants.Info.PROCEDURE_INPUTS);
                        List defaults = (List)node.getProperty(NodeConstants.Info.PROCEDURE_DEFAULTS);
                        Criteria crit = (Criteria)node.getProperty(NodeConstants.Info.PROCEDURE_CRITERIA);
                        DependentProcedureAccessNode depAccessNode = new DependentProcedureAccessNode(this.getID(), crit, references, defaults);
                        processNode = depAccessNode;
                        aNode = depAccessNode;
                    } else {
                        DependentAccessNode depAccessNode = new DependentAccessNode(this.getID());
                        if (modelID != null) {
                            depAccessNode.setPushdown(CapabilitiesUtil.supports(SourceCapabilities.Capability.DEPENDENT_JOIN, modelID, this.metadata, this.capFinder));
                            depAccessNode.setMaxSetSize(CapabilitiesUtil.getMaxInCriteriaSize(modelID, this.metadata, this.capFinder));
                            depAccessNode.setMaxPredicates(CapabilitiesUtil.getMaxDependentPredicates(modelID, this.metadata, this.capFinder));
                        }
                        processNode = depAccessNode;
                        aNode = depAccessNode;
                    }
                    aNode.setShouldEvaluateExpressions(true);
                } else {
                    aNode = new AccessNode(this.getID());
                    processNode = aNode;
                    try {
                        if (command instanceof Query) {
                            processNode = this.correctProjectionInternalTables(node, aNode);
                        }
                    }
                    catch (QueryMetadataException err) {
                        throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30248, (Throwable)((Object)err));
                    }
                    ev = EvaluatableVisitor.needsEvaluation(command);
                    aNode.setShouldEvaluateExpressions(ev.requiresEvaluation(EvaluatableVisitor.EvaluationLevel.PROCESSING));
                }
                if (command instanceof QueryCommand) {
                    try {
                        command = (Command)command.clone();
                        boolean aliasGroups = modelID != null && (CapabilitiesUtil.supportsGroupAliases(modelID, this.metadata, this.capFinder) || CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, modelID, this.metadata, this.capFinder));
                        boolean aliasColumns = modelID != null && (CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, modelID, this.metadata, this.capFinder) || CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, modelID, this.metadata, this.capFinder));
                        command.acceptVisitor(new AliasGenerator(aliasGroups, !aliasColumns));
                    }
                    catch (QueryMetadataException err) {
                        throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30249, (Throwable)((Object)err));
                    }
                }
                aNode.setCommand(command);
                if (this.minimizeProject() && !aNode.isShouldEvaluate()) {
                    aNode.minimizeProject(command);
                }
                this.setRoutingName(aNode, node);
                if (ev == null || ev.getDeterminismLevel().compareTo((Enum)FunctionMethod.Determinism.COMMAND_DETERMINISTIC) < 0 || !command.areResultsCachable()) break;
                this.checkForSharedSourceCommand(aNode);
                break;
            }
            case 16: {
                Criteria crit = (Criteria)node.getProperty(NodeConstants.Info.SELECT_CRITERIA);
                SelectNode selnode = new SelectNode(this.getID());
                selnode.setCriteria(crit);
                selnode.setProjectedExpressions((List)node.getProperty(NodeConstants.Info.PROJECT_COLS));
                processNode = selnode;
                break;
            }
            case 2: 
            case 32: {
                SortNode sortNode = new SortNode(this.getID());
                OrderBy orderBy = (OrderBy)node.getProperty(NodeConstants.Info.SORT_ORDER);
                if (orderBy != null) {
                    sortNode.setSortElements(orderBy.getOrderByItems());
                }
                if (node.getType() == 2) {
                    sortNode.setMode(SortUtility.Mode.DUP_REMOVE);
                } else if (node.hasBooleanProperty(NodeConstants.Info.IS_DUP_REMOVAL)) {
                    sortNode.setMode(SortUtility.Mode.DUP_REMOVE_SORT);
                }
                processNode = sortNode;
                break;
            }
            case 128: {
                GroupingNode gnode = new GroupingNode(this.getID());
                SymbolMap groupingMap = (SymbolMap)node.getProperty(NodeConstants.Info.SYMBOL_MAP);
                gnode.setOutputMapping(groupingMap);
                gnode.setRemoveDuplicates(node.hasBooleanProperty(NodeConstants.Info.IS_DUP_REMOVAL));
                List gCols = (List)node.getProperty(NodeConstants.Info.GROUP_COLS);
                OrderBy orderBy = (OrderBy)node.getProperty(NodeConstants.Info.SORT_ORDER);
                if (orderBy == null) {
                    if (gCols != null) {
                        orderBy = new OrderBy(RuleChooseJoinStrategy.createExpressionSymbols(gCols));
                    }
                } else {
                    for (int i = 0; i < gCols.size(); ++i) {
                        if (i < orderBy.getOrderByItems().size()) {
                            OrderByItem orderByItem = orderBy.getOrderByItems().get(i);
                            Expression ex = SymbolMap.getExpression(orderByItem.getSymbol());
                            if (!(ex instanceof ElementSymbol)) continue;
                            ex = groupingMap.getMappedExpression((ElementSymbol)ex);
                            orderByItem.setSymbol(new ExpressionSymbol("expr", ex));
                            continue;
                        }
                        orderBy.addVariable(new ExpressionSymbol("expr", (Expression)gCols.get(i)), true);
                    }
                }
                if (orderBy != null) {
                    gnode.setOrderBy(orderBy.getOrderByItems());
                }
                processNode = gnode;
                break;
            }
            case 64: {
                Object source = node.getProperty(NodeConstants.Info.TABLE_FUNCTION);
                if (source instanceof XMLTable) {
                    XMLTable xt = (XMLTable)source;
                    XMLTableNode xtn = new XMLTableNode(this.getID());
                    this.updateGroupName(node, xt);
                    Map<Expression, Integer> elementMap = RelationalNode.createLookupMap(xt.getProjectedSymbols());
                    List cols = (List)node.getProperty(NodeConstants.Info.OUTPUT_COLS);
                    int[] projectionIndexes = RelationalNode.getProjectionIndexes(elementMap, cols);
                    ArrayList<XMLTable.XMLColumn> filteredColumns = new ArrayList<XMLTable.XMLColumn>(projectionIndexes.length);
                    for (int col : projectionIndexes) {
                        filteredColumns.add(xt.getColumns().get(col));
                    }
                    xt.getXQueryExpression().useDocumentProjection(filteredColumns, this.analysisRecord);
                    xtn.setProjectedColumns(filteredColumns);
                    xtn.setTable(xt);
                    processNode = xtn;
                    break;
                }
                if (source instanceof TextTable) {
                    TextTableNode ttn = new TextTableNode(this.getID());
                    TextTable tt = (TextTable)source;
                    this.updateGroupName(node, tt);
                    ttn.setTable(tt);
                    processNode = ttn;
                    break;
                }
                if (source instanceof ArrayTable) {
                    ArrayTableNode atn = new ArrayTableNode(this.getID());
                    ArrayTable at = (ArrayTable)source;
                    this.updateGroupName(node, at);
                    atn.setTable(at);
                    processNode = atn;
                    break;
                }
                SymbolMap symbolMap = (SymbolMap)node.getProperty(NodeConstants.Info.SYMBOL_MAP);
                if (symbolMap != null) {
                    PlanNode child = node.getLastChild();
                    if (child.getType() == 8 || child.getType() == 16) {
                        child.setProperty(NodeConstants.Info.PROJECT_COLS, child.getProperty(NodeConstants.Info.OUTPUT_COLS));
                    }
                    child.setProperty(NodeConstants.Info.OUTPUT_COLS, node.getProperty(NodeConstants.Info.OUTPUT_COLS));
                }
                return null;
            }
            case 256: {
                SetQuery.Operation setOp = (SetQuery.Operation)((Object)node.getProperty(NodeConstants.Info.SET_OPERATION));
                boolean useAll = (Boolean)node.getProperty(NodeConstants.Info.USE_ALL);
                if (setOp == SetQuery.Operation.UNION) {
                    UnionAllNode unionAllNode = new UnionAllNode(this.getID());
                    if (useAll) {
                        processNode = unionAllNode;
                        break;
                    }
                    SortNode sNode = new SortNode(this.getID());
                    boolean onlyDupRemoval = node.hasBooleanProperty(NodeConstants.Info.IS_DUP_REMOVAL);
                    sNode.setMode(onlyDupRemoval ? SortUtility.Mode.DUP_REMOVE : SortUtility.Mode.DUP_REMOVE_SORT);
                    processNode = sNode;
                    unionAllNode.setElements((List)node.getProperty(NodeConstants.Info.OUTPUT_COLS));
                    processNode.addChild(unionAllNode);
                    break;
                }
                JoinNode joinAsSet = new JoinNode(this.getID());
                joinAsSet.setJoinStrategy(new MergeJoinStrategy(MergeJoinStrategy.SortOption.SORT_DISTINCT, MergeJoinStrategy.SortOption.SORT_DISTINCT, true));
                List leftExpressions = (List)node.getFirstChild().getProperty(NodeConstants.Info.OUTPUT_COLS);
                List rightExpressions = (List)node.getLastChild().getProperty(NodeConstants.Info.OUTPUT_COLS);
                joinAsSet.setJoinType(setOp == SetQuery.Operation.EXCEPT ? JoinType.JOIN_ANTI_SEMI : JoinType.JOIN_SEMI);
                joinAsSet.setJoinExpressions(leftExpressions, rightExpressions);
                processNode = joinAsSet;
                break;
            }
            case 1024: {
                Expression rowLimit = (Expression)node.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT);
                Expression offset = (Expression)node.getProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT);
                LimitNode ln = new LimitNode(this.getID(), rowLimit, offset);
                ln.setImplicit(node.hasBooleanProperty(NodeConstants.Info.IS_IMPLICIT_LIMIT));
                processNode = ln;
                break;
            }
            case 512: {
                processNode = new NullNode(this.getID());
                break;
            }
            default: {
                throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30250, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30250, new Object[]{NodeConstants.getNodeTypeString(node.getType())}));
            }
        }
        if (processNode != null) {
            processNode = this.prepareToAdd(node, processNode);
        }
        return processNode;
    }

    private void checkForSharedSourceCommand(AccessNode aNode) {
        AccessNode other;
        String modelName = aNode.getModelName();
        Command cmd = aNode.getCommand();
        if ("SYS".equals(modelName) || "SYSADMIN".equals(modelName) || TempMetadataAdapter.TEMP_MODEL.getName().equals(modelName)) {
            if (!(cmd instanceof Query)) {
                return;
            }
            Query query = (Query)cmd;
            if (query.getOrderBy() == null && query.getCriteria() == null) {
                return;
            }
        }
        if ((other = this.sharedCommands.get(cmd)) == null) {
            this.sharedCommands.put(cmd, aNode);
        } else {
            if (other.info == null) {
                other.info = new RegisterRequestParameter.SharedAccessInfo();
                other.info.id = sharedId.getAndIncrement();
            }
            ++other.info.sharingCount;
            aNode.info = other.info;
        }
    }

    private void updateGroupName(PlanNode node, TableFunctionReference tt) {
        String groupName = node.getGroups().iterator().next().getName();
        tt.getGroupSymbol().setName(groupName);
        for (ElementSymbol symbol : tt.getProjectedSymbols()) {
            symbol.setGroupSymbol(new GroupSymbol(groupName));
        }
    }

    private RelationalNode correctProjectionInternalTables(PlanNode node, AccessNode aNode) throws QueryMetadataException, TeiidComponentException {
        List<ElementSymbol> acutalColumns;
        if (node.getGroups().size() != 1) {
            return aNode;
        }
        GroupSymbol group = node.getGroups().iterator().next();
        if (!"SYS".equals(this.metadata.getFullName(this.metadata.getModelID(group.getMetadataID()))) && !"SYSADMIN".equals(this.metadata.getFullName(this.metadata.getModelID(group.getMetadataID())))) {
            return aNode;
        }
        List projectSymbols = (List)node.getProperty(NodeConstants.Info.OUTPUT_COLS);
        if (projectSymbols.equals(acutalColumns = ResolverUtil.resolveElementsInGroup(group, this.metadata))) {
            return aNode;
        }
        node.setProperty(NodeConstants.Info.OUTPUT_COLS, acutalColumns);
        if (node.getParent() != null && node.getParent().getType() == 8) {
            return aNode;
        }
        ProjectNode pnode = new ProjectNode(this.getID());
        pnode.setSelectSymbols(projectSymbols);
        aNode = (AccessNode)this.prepareToAdd(node, aNode);
        node.setProperty(NodeConstants.Info.OUTPUT_COLS, projectSymbols);
        pnode.addChild(aNode);
        return pnode;
    }

    private RelationalNode prepareToAdd(PlanNode node, RelationalNode processNode) {
        List cols = (List)node.getProperty(NodeConstants.Info.OUTPUT_COLS);
        processNode.setElements(cols);
        Number estimateNodeCardinality = (Number)node.getProperty(NodeConstants.Info.EST_CARDINALITY);
        processNode.setEstimateNodeCardinality(estimateNodeCardinality);
        Number estimateNodeSetSize = (Number)node.getProperty(NodeConstants.Info.EST_SET_SIZE);
        processNode.setEstimateNodeSetSize(estimateNodeSetSize);
        Number estimateDepAccessCardinality = (Number)node.getProperty(NodeConstants.Info.EST_DEP_CARDINALITY);
        processNode.setEstimateDepAccessCardinality(estimateDepAccessCardinality);
        Number estimateDepJoinCost = (Number)node.getProperty(NodeConstants.Info.EST_DEP_JOIN_COST);
        processNode.setEstimateDepJoinCost(estimateDepJoinCost);
        Number estimateJoinCost = (Number)node.getProperty(NodeConstants.Info.EST_JOIN_COST);
        processNode.setEstimateJoinCost(estimateJoinCost);
        return processNode;
    }

    private void setRoutingName(AccessNode accessNode, PlanNode node) throws QueryPlannerException, TeiidComponentException {
        try {
            Object modelID = node.getProperty(NodeConstants.Info.MODEL_ID);
            if (modelID == null || modelID instanceof TempMetadataID) {
                Command command = (Command)node.getProperty(NodeConstants.Info.ATOMIC_REQUEST);
                if (command instanceof StoredProcedure) {
                    modelID = ((StoredProcedure)command).getModelID();
                } else {
                    Collection<GroupSymbol> groups = GroupCollectorVisitor.getGroups((LanguageObject)command, true);
                    GroupSymbol group = groups.iterator().next();
                    modelID = this.metadata.getModelID(group.getMetadataID());
                }
            }
            String cbName = this.metadata.getFullName(modelID);
            accessNode.setModelName(cbName);
            accessNode.setModelId(modelID);
        }
        catch (QueryMetadataException e) {
            throw new QueryPlannerException(QueryPlugin.Event.TEIID30251, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30251, new Object[0]));
        }
    }

    protected boolean minimizeProject() {
        return true;
    }

    public static class SharedStateKey {
        int id;
        int expectedReaders;
    }
}

