/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheListener;
import org.teiid.core.util.LRUCache;

public class DefaultCache<K, V>
implements Cache<K, V>,
Serializable {
    private static final long serialVersionUID = -511120208522577206L;
    public static final int DEFAULT_MAX_SIZE_TOTAL = 250;
    public static final int DEFAULT_MAX_AGE = 0x6DDD00;
    protected LRUCache<K, ExpirationEntry<K, V>> map;
    protected Map<String, Cache> children = new ConcurrentHashMap<String, Cache>();
    protected String name;
    protected long ttl;
    protected Set<ExpirationEntry<K, V>> expirationQueue;

    public DefaultCache(String name) {
        this(name, 250, -1L);
    }

    public DefaultCache(String name, int maxEntries, long ttl) {
        this.map = new LRUCache<K, ExpirationEntry<K, V>>(maxEntries){

            protected boolean removeEldestEntry(Map.Entry<K, ExpirationEntry<K, V>> eldest) {
                Iterator iter;
                if (super.removeEldestEntry(eldest) && DefaultCache.this.validate((iter = DefaultCache.this.expirationQueue.iterator()).next()) != null) {
                    DefaultCache.this.remove(eldest.getKey());
                }
                return false;
            }
        };
        this.expirationQueue = Collections.newSetFromMap(new LRUCache(maxEntries));
        this.name = name;
        this.ttl = ttl;
    }

    public void addListener(CacheListener listener) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        LRUCache<K, ExpirationEntry<K, V>> lRUCache = this.map;
        synchronized (lRUCache) {
            this.map.clear();
            this.expirationQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        LRUCache<K, ExpirationEntry<K, V>> lRUCache = this.map;
        synchronized (lRUCache) {
            ExpirationEntry result = (ExpirationEntry)this.map.get(key);
            if (result != null) {
                return this.validate(result);
            }
            return null;
        }
    }

    private V validate(ExpirationEntry<K, V> result) {
        if (result.expiration < System.currentTimeMillis()) {
            this.remove(result.key);
            return null;
        }
        return result.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<K> keySet() {
        LRUCache<K, ExpirationEntry<K, V>> lRUCache = this.map;
        synchronized (lRUCache) {
            return new HashSet(this.map.keySet());
        }
    }

    public V put(K key, V value) {
        return this.put(key, value, this.ttl);
    }

    public static long getExpirationTime(long defaultTtl, Long ttl) {
        if (ttl == null) {
            ttl = defaultTtl;
        }
        if (ttl < 0L) {
            return Long.MAX_VALUE;
        }
        long result = System.currentTimeMillis() + ttl;
        if (result < ttl) {
            result = Long.MAX_VALUE;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value, Long timeToLive) {
        if (this.map.getSpaceLimit() == 0) {
            return null;
        }
        LRUCache<K, ExpirationEntry<K, V>> lRUCache = this.map;
        synchronized (lRUCache) {
            ExpirationEntry<K, V> entry = new ExpirationEntry<K, V>(DefaultCache.getExpirationTime(this.ttl, timeToLive), key, value);
            ExpirationEntry result = (ExpirationEntry)this.map.put(key, entry);
            this.expirationQueue.add(entry);
            if (result != null) {
                return result.value;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        LRUCache<K, ExpirationEntry<K, V>> lRUCache = this.map;
        synchronized (lRUCache) {
            ExpirationEntry result = (ExpirationEntry)this.map.remove(key);
            if (result != null) {
                this.expirationQueue.remove(result);
                return result.value;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        LRUCache<K, ExpirationEntry<K, V>> lRUCache = this.map;
        synchronized (lRUCache) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<V> values() {
        LRUCache<K, ExpirationEntry<K, V>> lRUCache = this.map;
        synchronized (lRUCache) {
            ArrayList<V> result = new ArrayList<V>(this.map.size());
            for (ExpirationEntry entry : new ArrayList(this.map.values())) {
                V value = this.validate(entry);
                if (value == null) continue;
                result.add(value);
            }
            return result;
        }
    }

    public Cache addChild(String name) {
        DefaultCache<K, V> c = this.children.get(name);
        if (c != null) {
            return c;
        }
        c = new DefaultCache<K, V>(name, this.map.getSpaceLimit(), this.ttl);
        this.children.put(name, c);
        return c;
    }

    public Cache getChild(String name) {
        return this.children.get(name);
    }

    public Collection<Cache> getChildren() {
        return this.children.values();
    }

    public boolean removeChild(String name) {
        Cache obj = this.children.remove(name);
        return obj != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keys() {
        LRUCache<K, ExpirationEntry<K, V>> lRUCache = this.map;
        synchronized (lRUCache) {
            return new HashSet(this.map.keySet());
        }
    }

    Set<ExpirationEntry<K, V>> getExpirationQueue() {
        return this.expirationQueue;
    }

    LRUCache<K, ExpirationEntry<K, V>> getCacheMap() {
        return this.map;
    }

    private static class ExpirationEntry<K, V> {
        long expiration;
        K key;
        V value;

        public ExpirationEntry(long expiration, K key, V value) {
            this.expiration = expiration;
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ExpirationEntry)) {
                return false;
            }
            ExpirationEntry other = (ExpirationEntry)obj;
            return this.key.equals(other.key);
        }
    }
}

