/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.jbmeta.javaee.environment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.metadata.javaee.jboss.JBossPortComponentRef;
import org.jboss.metadata.javaee.spec.PortComponentRef;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainsMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlersMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.switchboard.javaee.environment.Handler;
import org.jboss.switchboard.javaee.environment.HandlerChain;
import org.jboss.switchboard.javaee.environment.PortComponent;
import org.jboss.switchboard.javaee.environment.ServiceRefType;
import org.jboss.switchboard.javaee.util.EnvironmentEntryUtil;
import org.jboss.switchboard.jbmeta.javaee.environment.HandlerChainImpl;
import org.jboss.switchboard.jbmeta.javaee.environment.InjectionTargetConverter;
import org.jboss.switchboard.jbmeta.javaee.environment.JavaEEResource;
import org.jboss.switchboard.jbmeta.javaee.environment.ServiceHandler;
import org.jboss.switchboard.jbmeta.javaee.environment.ServicePortComponent;
import org.jboss.switchboard.jbmeta.javaee.jboss.environment.JBossPortComponentImpl;

public class ServiceReference
extends JavaEEResource
implements ServiceRefType {
    private ServiceReferenceMetaData delegate;
    private List<Handler> handlers;
    private List<HandlerChain> handlerChains;
    private Collection<PortComponent> portComponents;

    public ServiceReference(ServiceReferenceMetaData delegate) {
        super(delegate.getLookupName(), delegate.getMappedName(), InjectionTargetConverter.convert(delegate.getInjectionTargets()));
        this.delegate = delegate;
        this.initHandlers();
        this.initHandlerChains();
        this.initPortComponents();
    }

    public List<HandlerChain> getHandlerChains() {
        return this.handlerChains;
    }

    public Collection<Handler> getHandlers() {
        return this.handlers;
    }

    public String getHandlerChain() {
        return this.delegate.getHandlerChain();
    }

    public String getMappingFile() {
        return this.delegate.getJaxrpcMappingFile();
    }

    public Collection<PortComponent> getPortComponents() {
        return this.portComponents;
    }

    public QName getQName() {
        return this.delegate.getServiceQname();
    }

    public String getServiceInterface() {
        return this.delegate.getServiceInterface();
    }

    public String getType() {
        return this.delegate.getServiceRefType();
    }

    public String getWsdlFile() {
        return this.delegate.getWsdlFile();
    }

    public String getName() {
        return EnvironmentEntryUtil.getENCName((String)this.delegate.getServiceRefName());
    }

    public String getAddressingResponses() {
        return this.delegate.getAddressingResponses();
    }

    public int getMtomThreshold() {
        return this.delegate.getMtomThreshold();
    }

    public boolean isAddressingEnabled() {
        return this.delegate.isAddressingEnabled();
    }

    public boolean isAddressingRequired() {
        return this.delegate.isAddressingRequired();
    }

    public boolean isMtomEnabled() {
        return this.delegate.isMtomEnabled();
    }

    public boolean isRespectBindingEnabled() {
        return this.delegate.isRespectBindingEnabled();
    }

    public boolean isAddressingFeatureEnabled() {
        return this.delegate.isAddressingAnnotationSpecified();
    }

    public boolean isMtomFeatureEnabled() {
        return this.delegate.isMtomAnnotationSpecified();
    }

    public boolean isRespectBindingFeatureEnabled() {
        return this.delegate.isRespectBindingAnnotationSpecified();
    }

    private void initHandlers() {
        if (this.delegate.getHandlers() == null) {
            return;
        }
        ServiceReferenceHandlersMetaData serviceHandlers = this.delegate.getHandlers();
        this.handlers = new ArrayList<Handler>(serviceHandlers.size());
        for (ServiceReferenceHandlerMetaData serviceHandler : serviceHandlers) {
            this.handlers.add(new ServiceHandler(serviceHandler));
        }
    }

    private void initPortComponents() {
        if (this.delegate.getPortComponentRef() == null) {
            return;
        }
        List portComponentRefs = this.delegate.getPortComponentRef();
        this.portComponents = new ArrayList<PortComponent>(portComponentRefs.size());
        for (PortComponentRef portCompRef : portComponentRefs) {
            if (portCompRef instanceof JBossPortComponentRef) {
                this.portComponents.add(new JBossPortComponentImpl((JBossPortComponentRef)portCompRef));
                continue;
            }
            this.portComponents.add(new ServicePortComponent(portCompRef));
        }
    }

    private void initHandlerChains() {
        if (this.delegate.getHandlerChains() == null) {
            return;
        }
        ServiceReferenceHandlerChainsMetaData serviceHandlers = this.delegate.getHandlerChains();
        List srhcList = serviceHandlers.getHandlers();
        this.handlerChains = new ArrayList<HandlerChain>(srhcList.size());
        for (ServiceReferenceHandlerChainMetaData handlerChain : srhcList) {
            this.handlerChains.add(new HandlerChainImpl(handlerChain));
        }
    }
}

