/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.switchboard.javaee.environment;

import java.util.Properties;

import org.jboss.switchboard.spi.EnvironmentEntryType;

/**
 * Represents a &lt;data-source&gt; and @DataSourceDefinition reference in a 
 * Java EE component
 *
 * @author Jaikiran Pai
 * @version $Revision: $
 */
public interface DataSourceType extends EnvironmentEntryType
{

   /**
    * Returns the fully qualified class name of DataSource, XADataSource or ConnectionPoolDataSource
    * implementation class.
    * @return
    */
   String getClassName();
   
   /**
    * @return Returns the database server name
    */
   String getServerName();
   
   /**
    * 
    * @return Returns the port number where the database server is listening for requests.
    */
   int getPort();
   
   /**
    * @return Returns the name of the database on the database server.
    */
   String getDatabaseName();
   
   /**
    * @return Returns the JDBC URL.
    * 
    */
   String getURL();
   
   /**
    * 
    * @return Returns the user name that will be used for connecting to the database
    */
   String getUserName();
   
   /**
    * 
    * @return Returns the password that will be used for connecting to the database
    */
   String getPassword();
   
   /**
    * Returns the JDBC DataSource properties.  This may be a vendor-specific
    *        properties or a less commonly used DataSource properties
    * @return
    */
   Properties getProperties();
   
   /**
    * Returns the maximum time in seconds that this data source
    *        will wait while attempting to connect to a database.
    * @return
    */
   int getLoginTimeout(); 
   
   
   /**
    * Returns true if connections from this datasource participate in transactions.
    * Else returns false
    * @return
    */
   boolean isTransactional();
   
   /**
    * Returns the isolation level for the connections created from this datasource
    * @return
    */
   ConnectionIsolationLevel getIsolationLevel();
   
   /**
    * Returns the number of connections that should be created when a connection pool is initialized.
    * @return
    */
   int getInitialPoolSize();
   
   /**
    * Returns the maximum number of connections that should be allocated, at any given time,
    * in the pool.
    * 
    * @return
    */
   int getMaxPoolSize();
   
   /**
    * Returns the minimum number of connections that should be allocated, at any given time,
    * in the pool.
    * @return
    */
   int getMinPoolSize();
   
   /**
    * Returns the number of seconds that a physical connection should remain unused in the pool 
    * before the connection is closed from the connection pool.
    * @return
    */
   int getMaxIdleTime();
   
   /**
    * Returns the total number of statements that a connection pool should keep open.
    * @return
    */
   int getMaxStatements();
}
