/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.staxmapper;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.staxmapper.FormattingXMLStreamWriter;
import org.jboss.staxmapper.XMLAttributeReader;
import org.jboss.staxmapper.XMLContentWriter;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamReaderImpl;
import org.jboss.staxmapper.XMLMapper;

final class XMLMapperImpl
implements XMLMapper {
    private final ConcurrentMap<QName, XMLElementReader<?>> rootElements = new ConcurrentHashMap();
    private final ConcurrentMap<QName, XMLAttributeReader<?>> rootAttributes = new ConcurrentHashMap();

    XMLMapperImpl() {
    }

    @Override
    public void registerRootElement(QName name, XMLElementReader<?> reader) {
        if (this.rootElements.putIfAbsent(name, reader) != null) {
            throw new IllegalArgumentException("Root element for " + name + " already registered");
        }
    }

    @Override
    public void registerRootAttribute(QName name, XMLAttributeReader<?> reader) {
        if (this.rootAttributes.putIfAbsent(name, reader) != null) {
            throw new IllegalArgumentException("Root attribute for " + name + " already registered");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseDocument(Object rootObject, XMLStreamReader reader) throws XMLStreamException {
        try {
            reader.require(7, null, null);
            reader.nextTag();
            reader.require(1, null, null);
            this.processNested(new XMLExtendedStreamReaderImpl(this, reader), rootObject);
            while (reader.next() != 8) {
            }
            reader.close();
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void deparseDocument(XMLContentWriter contentWriter, XMLStreamWriter streamWriter) throws XMLStreamException {
        contentWriter.writeContent(new FormattingXMLStreamWriter(streamWriter));
    }

    <T> void processNested(XMLExtendedStreamReader streamReader, T value) throws XMLStreamException {
        QName name = streamReader.getName();
        XMLElementReader reader = (XMLElementReader)this.rootElements.get(name);
        if (reader == null) {
            throw new XMLStreamException("Unexpected element '" + name + "'", streamReader.getLocation());
        }
        reader.readElement(streamReader, value);
    }

    <T> void processAttribute(XMLStreamReader streamReader, int index, T value) throws XMLStreamException {
        QName name = streamReader.getName();
        XMLAttributeReader reader = (XMLAttributeReader)this.rootAttributes.get(name);
        if (reader == null) {
            throw new XMLStreamException("Unexpected attribute '" + name + "'", streamReader.getLocation());
        }
        reader.readAttribute(streamReader, index, value);
    }
}

