/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.nio.file;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.impl.nio.file.ShrinkWrapFileSystem;
import org.jboss.shrinkwrap.impl.nio.file.ShrinkWrapPath;

class ShrinkWrapDirectoryStream
implements DirectoryStream<Path> {
    private final ShrinkWrapFileSystem fs;
    private final DirectoryStream.Filter<? super Path> filter;
    private final Path startingPath;
    private boolean closed = false;
    private boolean iteratorReturned = false;

    ShrinkWrapDirectoryStream(Path startingPath, ShrinkWrapFileSystem fs, DirectoryStream.Filter<? super Path> filter) throws IllegalArgumentException {
        if (fs == null) {
            throw new IllegalArgumentException("File system must be specified");
        }
        if (startingPath == null) {
            throw new IllegalArgumentException("Starting path must be specified");
        }
        this.startingPath = startingPath.toAbsolutePath();
        this.fs = fs;
        this.filter = filter;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public Iterator<Path> iterator() {
        if (this.closed) {
            throw new IllegalStateException("Directory Stream is closed");
        }
        if (this.iteratorReturned) {
            throw new IllegalStateException("Iterator was already returned");
        }
        boolean finishedSuccessfully = true;
        try {
            Map content = this.fs.getArchive().getContent();
            ArrayList<ShrinkWrapPath> newPaths = new ArrayList<ShrinkWrapPath>(content.size());
            Set archivePaths = content.keySet();
            for (ArchivePath path : archivePaths) {
                ShrinkWrapPath newPath = new ShrinkWrapPath(path, this.fs);
                if (!newPath.getParent().equals(this.startingPath)) continue;
                try {
                    if (this.filter != null && !this.filter.accept(newPath)) {
                        continue;
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Error encountered during filtering", ioe);
                }
                newPaths.add(newPath);
            }
            Iterator<Path> iterator = newPaths.iterator();
            return iterator;
        }
        catch (Throwable t) {
            finishedSuccessfully = false;
            throw t;
        }
        finally {
            if (finishedSuccessfully) {
                this.iteratorReturned = true;
            }
        }
    }
}

