/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.path.PathUtil;

public class ExcludePaths
implements Filter<ArchivePath> {
    private final Set<String> paths;

    public ExcludePaths(String ... paths) {
        Validate.notNull(paths, "Paths must be specified");
        this.paths = this.adjust(paths);
    }

    public ExcludePaths(Collection<String> paths) {
        Validate.notNull(paths, "Paths must be specified");
        this.paths = this.adjust(paths.toArray(new String[0]));
    }

    private Set<String> adjust(String ... paths) {
        HashSet<String> adjusted = new HashSet<String>();
        for (String path : paths) {
            adjusted.add(PathUtil.optionallyPrependSlash(path));
        }
        return adjusted;
    }

    public boolean include(ArchivePath path) {
        return !this.paths.contains(path.get());
    }
}

