/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api;

import java.util.ArrayList;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ClassLoaderSearchUtil;
import org.jboss.shrinkwrap.api.SecurityActions;

public final class ArchivePaths {
    private static final String PATH_IMPL = "org.jboss.shrinkwrap.impl.base.path.BasicPath";
    private static final Class<?> archivePathImplClass;

    public static ArchivePath root() {
        return RootPathWrapper.INSTANCE.getRoot();
    }

    public static ArchivePath create(String context) {
        return ArchivePaths.createInstance(new Class[]{String.class}, new Object[]{context});
    }

    public static ArchivePath create(String basePath, String context) {
        return ArchivePaths.createInstance(new Class[]{String.class, String.class}, new Object[]{basePath, context});
    }

    public static ArchivePath create(String basePath, ArchivePath context) {
        return ArchivePaths.createInstance(new Class[]{String.class, ArchivePath.class}, new Object[]{basePath, context});
    }

    public static ArchivePath create(ArchivePath basePath, String context) {
        return ArchivePaths.createInstance(new Class[]{ArchivePath.class, String.class}, new Object[]{basePath, context});
    }

    public static ArchivePath create(ArchivePath basePath, ArchivePath context) {
        return ArchivePaths.createInstance(new Class[]{ArchivePath.class, ArchivePath.class}, new Object[]{basePath, context});
    }

    private static ArchivePath createInstance(Class<?>[] argumentTypes, Object[] arguments) {
        return SecurityActions.newInstance(archivePathImplClass, argumentTypes, arguments, ArchivePath.class);
    }

    private ArchivePaths() {
    }

    static {
        ArrayList<ClassLoader> searchClassLoaders = new ArrayList<ClassLoader>();
        searchClassLoaders.add(ArchivePaths.class.getClassLoader());
        try {
            archivePathImplClass = ClassLoaderSearchUtil.findClassFromClassLoaders(PATH_IMPL, searchClassLoaders);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Could not find the archive path implementation class org.jboss.shrinkwrap.impl.base.path.BasicPath in any configured ClassLoader", cnfe);
        }
    }

    private static enum RootPathWrapper {
        INSTANCE;

        private final ArchivePath root = ArchivePaths.create(null);

        private ArchivePath getRoot() {
            return this.root;
        }
    }
}

