/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;

final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(GetTcclAction.INSTANCE);
    }

    static Constructor<?> getConstructor(final Class<?> clazz, final Class<?> ... argumentTypes) throws NoSuchMethodException {
        try {
            return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>>(){

                @Override
                public Constructor<?> run() throws NoSuchMethodException {
                    return clazz.getConstructor(argumentTypes);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static <T> T newInstance(Class<?> clazz, Class<?>[] argumentTypes, Object[] arguments, Class<T> expectedType) {
        Object obj;
        Constructor<?> constructor;
        if (clazz == null) {
            throw new IllegalArgumentException("Class must be specified");
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException("ArgumentTypes must be specified. Use empty array if no arguments");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Arguments must be specified. Use empty array if no arguments");
        }
        if (expectedType == null) {
            throw new IllegalArgumentException("Expected type must be specified");
        }
        try {
            constructor = SecurityActions.getConstructor(clazz, argumentTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not create new instance of " + clazz + " using ctor argument types " + Arrays.asList(argumentTypes), e);
        }
        try {
            obj = constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a new instance of " + clazz + " using arguments " + Arrays.asList(arguments), e);
        }
        try {
            return expectedType.cast(obj);
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Incorrect expected type, " + expectedType.getName() + ", defined for " + obj.getClass().getName());
        }
    }

    static <T> T newInstance(String className, Class<?>[] argumentTypes, Object[] arguments, Class<T> expectedType, ClassLoader cl) {
        Class<?> implClass;
        if (className == null) {
            throw new IllegalArgumentException("ClassName must be specified");
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException("ArgumentTypes must be specified. Use empty array if no arguments");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Arguments must be specified. Use empty array if no arguments");
        }
        if (expectedType == null) {
            throw new IllegalArgumentException("Expected type must be specified");
        }
        if (cl == null) {
            throw new IllegalArgumentException("CL must be specified");
        }
        try {
            implClass = Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("Could not find class named " + className + " in the specified CL: " + cl, cnfe);
        }
        return SecurityActions.newInstance(implClass, argumentTypes, arguments, expectedType);
    }

    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

