/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.nio.file;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.HashMap;
import org.jboss.shrinkwrap.api.Archive;

public final class ShrinkWrapFileSystems {
    public static final String PROTOCOL = "shrinkwrap";
    public static final String FS_ENV_KEY_ARCHIVE = "archive";
    private static final String URI_PROTOCOL_SUFFIX = "://";

    private ShrinkWrapFileSystems() {
        throw new UnsupportedOperationException("Class with only static methods");
    }

    public static FileSystem newFileSystem(Archive<?> archive) throws IllegalArgumentException, IOException {
        if (archive == null) {
            throw new IllegalArgumentException("Archive must be specified");
        }
        HashMap environment = new HashMap();
        environment.put(FS_ENV_KEY_ARCHIVE, archive);
        URI uri = ShrinkWrapFileSystems.getRootUri(archive);
        FileSystem fs = FileSystems.newFileSystem(uri, environment);
        return fs;
    }

    public static URI getRootUri(Archive<?> archive) throws IllegalArgumentException {
        if (archive == null) {
            throw new IllegalArgumentException("Archive must be specified");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(PROTOCOL);
        sb.append(URI_PROTOCOL_SUFFIX);
        sb.append(archive.getId());
        sb.append('/');
        URI uri = URI.create(sb.toString());
        return uri;
    }
}

