/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Properties;
import org.jboss.shrinkwrap.resolver.impl.maven.GetTcclAction;

final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(GetTcclAction.INSTANCE);
    }

    static String getProperty(String key) {
        try {
            String value = AccessController.doPrivileged(() -> System.getProperty(key));
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static Properties getProperties() {
        try {
            Properties value = AccessController.doPrivileged(System::getProperties);
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }
}

