/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.bootstrap;

import java.io.File;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.artifact.DefaultArtifactTypeRegistry;
import org.eclipse.aether.util.graph.manager.ClassicDependencyManager;
import org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.JavaDependencyContextRefiner;
import org.eclipse.aether.util.graph.transformer.JavaScopeDeriver;
import org.eclipse.aether.util.graph.transformer.JavaScopeSelector;
import org.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import org.eclipse.aether.util.graph.traverser.FatArtifactTraverser;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.jboss.shrinkwrap.resolver.impl.maven.aether.ClasspathWorkspaceReader;
import org.jboss.shrinkwrap.resolver.impl.maven.bootstrap.SecurityActions;
import org.jboss.shrinkwrap.resolver.impl.maven.convert.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.logging.LogRepositoryListener;
import org.jboss.shrinkwrap.resolver.impl.maven.logging.LogTransferListener;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

class MavenManagerBuilder {
    public static final String USE_LEGACY_REPO_KEY = "maven.legacyLocalRepo";
    private final Settings settings;
    private final RepositorySystem system;
    private final boolean useLegacyLocalRepository;

    MavenManagerBuilder(RepositorySystem system, Settings settings) {
        this.system = system;
        this.settings = settings;
        this.useLegacyLocalRepository = Boolean.parseBoolean(SecurityActions.getProperty(USE_LEGACY_REPO_KEY));
    }

    public TransferListener transferListerer() {
        return new LogTransferListener();
    }

    public RepositoryListener repositoryListener() {
        return new LogRepositoryListener();
    }

    public LocalRepositoryManager localRepositoryManager(RepositorySystemSession session, boolean legacyLocalRepository) {
        Validate.notNull(session, "session must be specified");
        String localRepositoryPath = this.settings.getLocalRepository();
        Validate.notNullOrEmpty(localRepositoryPath, "Path to a local repository must be defined");
        SWRLocalRepositoryManager factory = SWRLocalRepositoryManager.ENHANCED;
        if (this.useLegacyLocalRepository || legacyLocalRepository) {
            factory = SWRLocalRepositoryManager.LEGACY;
        }
        if (this.settings.isOffline()) {
            factory = SWRLocalRepositoryManager.SIMPLE;
        }
        LocalRepositoryManager manager = factory.localRepositoryManager(this.system, session, new File(localRepositoryPath));
        return manager;
    }

    public MirrorSelector mirrorSelector() {
        DefaultMirrorSelector dms = new DefaultMirrorSelector();
        for (Mirror mirror : this.settings.getMirrors()) {
            dms.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        return dms;
    }

    public ProxySelector proxySelector() {
        DefaultProxySelector dps = new DefaultProxySelector();
        for (Proxy proxy : this.settings.getProxies()) {
            dps.add(MavenConverter.asProxy(proxy), proxy.getNonProxyHosts());
        }
        return dps;
    }

    public WorkspaceReader workspaceReader() {
        return new ClasspathWorkspaceReader();
    }

    public DependencyManager dependencyManager() {
        return new ClassicDependencyManager();
    }

    public ArtifactDescriptorPolicy artifactRepositoryPolicy() {
        return new SimpleArtifactDescriptorPolicy(true, true);
    }

    public ArtifactTypeRegistry artifactTypeRegistry() {
        DefaultArtifactTypeRegistry stereotypes = new DefaultArtifactTypeRegistry();
        stereotypes.add((ArtifactType)new DefaultArtifactType("pom"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("maven-plugin", "jar", "", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("jar", "jar", "", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("ejb", "jar", "", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("ejb-client", "jar", "client", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("test-jar", "jar", "tests", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("javadoc", "jar", "javadoc", "java"));
        stereotypes.add((ArtifactType)new DefaultArtifactType("java-source", "jar", "sources", "java", false, false));
        stereotypes.add((ArtifactType)new DefaultArtifactType("war", "war", "", "java", false, true));
        stereotypes.add((ArtifactType)new DefaultArtifactType("ear", "ear", "", "java", false, true));
        stereotypes.add((ArtifactType)new DefaultArtifactType("rar", "rar", "", "java", false, true));
        stereotypes.add((ArtifactType)new DefaultArtifactType("par", "par", "", "java", false, true));
        return stereotypes;
    }

    public DependencyTraverser dependencyTraverser() {
        return new FatArtifactTraverser();
    }

    public DependencyGraphTransformer dependencyGraphTransformer() {
        ConflictResolver transformer = new ConflictResolver((ConflictResolver.VersionSelector)new NearestVersionSelector(), (ConflictResolver.ScopeSelector)new JavaScopeSelector(), (ConflictResolver.OptionalitySelector)new SimpleOptionalitySelector(), (ConflictResolver.ScopeDeriver)new JavaScopeDeriver());
        return new ChainedDependencyGraphTransformer(new DependencyGraphTransformer[]{transformer, new JavaDependencyContextRefiner()});
    }

    private static enum SWRLocalRepositoryManager {
        SIMPLE{

            @Override
            public LocalRepositoryManager localRepositoryManager(RepositorySystem system, RepositorySystemSession session, File localRepositoryPath) {
                return system.newLocalRepositoryManager(session, new LocalRepository(localRepositoryPath, "simple"));
            }
        }
        ,
        ENHANCED{

            @Override
            public LocalRepositoryManager localRepositoryManager(RepositorySystem system, RepositorySystemSession session, File localRepositoryPath) {
                return system.newLocalRepositoryManager(session, new LocalRepository(localRepositoryPath, "default"));
            }
        }
        ,
        LEGACY{

            @Override
            public LocalRepositoryManager localRepositoryManager(RepositorySystem system, RepositorySystemSession session, File localRepositoryPath) {
                return system.newLocalRepositoryManager(session, new LocalRepository(localRepositoryPath, "simple"));
            }
        };


        public abstract LocalRepositoryManager localRepositoryManager(RepositorySystem var1, RepositorySystemSession var2, File var3);
    }
}

