/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.jboss.shrinkwrap.resolver.api.maven.filter.MavenResolutionFilter;

class PostResolutionFilterApplicator {
    private static final Logger log = Logger.getLogger(PostResolutionFilterApplicator.class.getName());

    PostResolutionFilterApplicator() {
    }

    static Collection<MavenResolvedArtifact> postFilter(Collection<MavenResolvedArtifact> artifactResults) {
        RestrictPomArtifactFilter postResolutionFilter = RestrictPomArtifactFilter.INSTANCE;
        ArrayList<MavenResolvedArtifact> filteredArtifacts = new ArrayList<MavenResolvedArtifact>();
        List emptyList = Collections.emptyList();
        for (MavenResolvedArtifact artifact : artifactResults) {
            MavenDependency dependency = MavenDependencies.createDependency((MavenCoordinate)artifact.getCoordinate(), (ScopeType)ScopeType.COMPILE, (boolean)false, (MavenDependencyExclusion[])new MavenDependencyExclusion[0]);
            if (!postResolutionFilter.accepts(dependency, emptyList, emptyList)) continue;
            filteredArtifacts.add(artifact);
        }
        return Collections.unmodifiableCollection(filteredArtifacts);
    }

    private static enum RestrictPomArtifactFilter implements MavenResolutionFilter
    {
        INSTANCE;


        public boolean accepts(MavenDependency coordinate, List<MavenDependency> dependenciesForResolution, List<MavenDependency> dependencyAncestors) throws IllegalArgumentException {
            if (PackagingType.POM.equals((Object)coordinate.getPackaging())) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Filtering out POM dependency resolution: " + coordinate + "; its transitive dependencies will be included");
                }
                return false;
            }
            return true;
        }
    }
}

