/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.embedded;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.task.archive.UntarTool;
import org.arquillian.spacelift.task.archive.UnzipTool;
import org.jboss.shrinkwrap.resolver.impl.maven.embedded.MarkerFileHandler;

class FileExtractor {
    private final File fileToExtract;
    private final File destinationDir;
    private final MarkerFileHandler markerFileHandler;

    private FileExtractor(File fileToExtract, File destinationDir) {
        this.fileToExtract = fileToExtract;
        this.destinationDir = destinationDir;
        this.markerFileHandler = new MarkerFileHandler(destinationDir, "extractionIsProcessing.tmp");
    }

    static File extract(File fileToExtract, File destinationDir) {
        return new FileExtractor(fileToExtract, destinationDir).extract();
    }

    private File extract() {
        File withExtractedDir = this.checkIfItIsAlreadyExtracted();
        if (withExtractedDir != null) {
            return withExtractedDir;
        }
        this.destinationDir.mkdirs();
        this.extractFileInDestinationDir();
        return this.destinationDir;
    }

    private void extractFileInDestinationDir() {
        block5: {
            this.markerFileHandler.createMarkerFile();
            String downloadedPath = this.fileToExtract.getAbsolutePath();
            try {
                if (downloadedPath.endsWith(".zip")) {
                    ((UnzipTool)Spacelift.task((Object)this.fileToExtract, UnzipTool.class)).toDir(this.destinationDir).execute().await();
                    break block5;
                }
                if (downloadedPath.endsWith(".tar.gz")) {
                    ((UntarTool)Spacelift.task((Object)this.fileToExtract, UntarTool.class)).gzip(true).toDir(this.destinationDir).execute().await();
                    break block5;
                }
                if (downloadedPath.endsWith(".tar.bz2")) {
                    ((UntarTool)Spacelift.task((Object)this.fileToExtract, UntarTool.class)).bzip2(true).toDir(this.destinationDir).execute().await();
                    break block5;
                }
                throw new IllegalArgumentException("The distribution " + this.fileToExtract + " is compressed by unsupported format. Supported formats are .zip, .tar.gz, .tar.bz2");
            }
            catch (ExecutionException ee) {
                throw new IllegalStateException("Something bad happened when the file: " + downloadedPath + " was being extracted. For more information see the stacktrace", ee);
            }
        }
        this.markerFileHandler.deleteMarkerFile();
        System.out.println(String.format("Resolver: Successfully extracted maven binaries from %s", this.fileToExtract));
    }

    private File checkIfItIsAlreadyExtracted() {
        if (this.destinationDir.exists() && this.destinationDir.isDirectory() && this.destinationDir.list().length > 0 && this.isExtractionFinished()) {
            return this.destinationDir;
        }
        return null;
    }

    private boolean isExtractionFinished() {
        boolean fileIsStillPresent = this.markerFileHandler.waitTillMarkerFileIsGone(10000L, "extraction");
        if (fileIsStillPresent) {
            try {
                this.deleteFileRecursively(this.destinationDir.toPath());
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to delete directory:" + this.destinationDir, e);
            }
        }
        return true;
    }

    private void deleteFileRecursively(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

