/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.File;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.javac.JavacCompiler;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.SpaceModule;
import org.eclipse.sisu.space.URLClassSpace;
import org.eclipse.sisu.wire.WireModule;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.archive.importer.MavenImporterException;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.AcceptScopesStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins.CompilerPluginConfiguration;
import org.jboss.shrinkwrap.resolver.impl.maven.task.AddScopedDependenciesTask;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.jboss.shrinkwrap.resolver.spi.maven.archive.packaging.PackagingProcessor;

public abstract class AbstractCompilingProcessor<ARCHIVETYPE extends Archive<ARCHIVETYPE>>
implements PackagingProcessor<ARCHIVETYPE> {
    private static final Logger log = Logger.getLogger(AbstractCompilingProcessor.class.getName());
    private static final Pattern UUID4_PATTERN = Pattern.compile("[a-f0-9]{8}-[a-f0-9]{4}-4[a-f0-9]{3}-[89aAbB][a-f0-9]{3}-[a-f0-9]{12}\\.[a-z]+");
    private JavacCompiler compiler;
    private boolean skipCompilation;
    protected MavenWorkingSession session;

    protected PackagingProcessor<ARCHIVETYPE> configure(MavenWorkingSession session) {
        this.session = session;
        boolean bl = this.skipCompilation = Boolean.getBoolean("org.jboss.shrinkwrap.resolver.maven.skipCompilation") || session.skipCompilation();
        if (this.skipCompilation) {
            log.fine("Compilation was skipped due to system property org.jboss.shrinkwrap.resolver.maven.importer.skipCompilation being set to true");
        } else {
            this.compiler = (JavacCompiler)Guice.createInjector((Module[])new Module[]{new WireModule(new Module[]{new SpaceModule((ClassSpace)new URLClassSpace(AbstractCompilingProcessor.class.getClassLoader()), SpaceModule.LOCAL_INDEX, true)})}).getInstance(JavacCompiler.class);
        }
        return this;
    }

    protected AbstractCompilingProcessor<ARCHIVETYPE> compile(File inputDirectory, File outputDirectory, ScopeType ... scopes) {
        block8: {
            Validate.notNullAndNoNullValues((Object[])scopes, (String)"Cannot compile sources, there were no scopes defined");
            Validate.notNull((Object)inputDirectory, (String)"Directory with sources to be compiled must not be null");
            Validate.notNull((Object)outputDirectory, (String)"Target directory for compiled sources must not be null");
            if (this.compiler == null) {
                if (!this.skipCompilation) {
                    log.warning("No compiler found, skipping compilation");
                }
                return this;
            }
            CompilerConfiguration configuration = this.getCompilerConfiguration();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Compiling sources from {0} directory into {1}", new Object[]{inputDirectory, outputDirectory});
            }
            new AddScopedDependenciesTask(ScopeType.values()).execute(this.session);
            AcceptScopesStrategy scopeStrategy = new AcceptScopesStrategy(scopes);
            Collection artifactResults = this.session.resolveDependencies((MavenResolutionStrategy)scopeStrategy);
            for (MavenResolvedArtifact artifact : artifactResults) {
                String classpathEntry = artifact.asFile().getAbsolutePath();
                configuration.addClasspathEntry(classpathEntry);
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, "Adding {0} to compilation classpath", classpathEntry);
            }
            configuration.addSourceLocation(inputDirectory.getPath());
            configuration.setOutputLocation(outputDirectory.getPath());
            try {
                CompilerResult result = this.compiler.performCompile(configuration);
                if (result.isSuccess()) break block8;
                if (!configuration.isFork()) {
                    log.log(Level.WARNING, "MavenImporter was not able to identify javac compiler, probably JAVA_HOME points to JRE instead of JDK. MavenImporter will try to fork and use javac from $PATH");
                    configuration.setFork(true);
                    CompilerResult result2 = this.compiler.performCompile(configuration);
                    if (!result2.isSuccess()) {
                        log.log(Level.WARNING, "Unable to compile project with neither forked nor embedded compiler. Returning original exception message");
                        throw AbstractCompilingProcessor.constructCompilationException(result, inputDirectory);
                    }
                    break block8;
                }
                throw AbstractCompilingProcessor.constructCompilationException(result, inputDirectory);
            }
            catch (CompilerException e) {
                log.log(Level.SEVERE, "Compilation failed with {0}", e.getMessage());
                throw new MavenImporterException("Unable to compile source at " + inputDirectory.getPath() + " due to: ", (Throwable)e);
            }
        }
        return this;
    }

    private CompilerConfiguration getCompilerConfiguration() {
        CompilerPluginConfiguration pluginConfiguration = new CompilerPluginConfiguration(this.session.getParsedPomFile());
        return pluginConfiguration.asCompilerConfiguration();
    }

    protected static boolean hasGeneratedName(Archive<?> archive) {
        String archiveName = archive.getName();
        return archiveName != null && UUID4_PATTERN.matcher(archiveName.toLowerCase()).matches();
    }

    private static MavenImporterException constructCompilationException(CompilerResult result, File sourceDirectory) {
        StringBuilder sb = new StringBuilder("Unable to compile sources at ");
        sb.append(sourceDirectory.getPath());
        sb.append(" due to following reason(s): ");
        String delimiter = "";
        for (CompilerMessage m : result.getCompilerMessages()) {
            sb.append(delimiter).append(m.toString());
            delimiter = ", ";
        }
        log.log(Level.SEVERE, sb.toString());
        return new MavenImporterException(sb.toString());
    }
}

