/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import org.codehaus.plexus.util.AbstractScanner;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging.AbstractCompilingProcessor;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging.ManifestAsset;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins.JarPluginConfiguration;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.jboss.shrinkwrap.resolver.spi.maven.archive.packaging.PackagingProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarPackagingProcessor
extends AbstractCompilingProcessor<JavaArchive>
implements PackagingProcessor<JavaArchive> {
    public static final String MAVEN_WAR_PLUGIN_KEY = "org.apache.maven.plugins:maven-jar-plugin";
    private JavaArchive archive;

    public boolean handles(PackagingType packagingType) {
        return PackagingType.JAR.equals((Object)packagingType);
    }

    public JarPackagingProcessor configure(Archive<?> archive, MavenWorkingSession session) {
        super.configure(session);
        this.archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)session.getParsedPomFile().getFinalName());
        return this;
    }

    public JarPackagingProcessor importBuildOutput(MavenResolutionStrategy strategy) throws ResolutionException, IllegalArgumentException, UnsupportedOperationException {
        ParsedPomFile pomFile = this.session.getParsedPomFile();
        if (Validate.isReadable((File)pomFile.getSourceDirectory())) {
            this.compile(pomFile.getSourceDirectory(), pomFile.getBuildOutputDirectory(), ScopeType.COMPILE, ScopeType.IMPORT, ScopeType.PROVIDED, ScopeType.RUNTIME, ScopeType.SYSTEM);
            JavaArchive classes = (JavaArchive)((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)"sources.jar")).importDirectory(pomFile.getBuildOutputDirectory()).as(JavaArchive.class);
            this.archive = (JavaArchive)this.archive.merge((Archive)classes);
        }
        JarPluginConfiguration jarConfiguration = new JarPluginConfiguration(pomFile);
        ListFilter listFilter = new ListFilter();
        listFilter.setIncludes(jarConfiguration.getIncludes());
        listFilter.setExcludes(jarConfiguration.getExcludes());
        listFilter.addDefaultExcludes();
        for (File resource : listFilter.scan(pomFile.getProjectResources(), pomFile.getBaseDirectory())) {
            this.archive.addAsResource(resource);
        }
        Manifest manifest = jarConfiguration.getArchiveConfiguration().asManifest();
        this.archive.setManifest((Asset)new ManifestAsset(manifest));
        return this;
    }

    public JavaArchive getResultingArchive() {
        return this.archive;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListFilter
    extends AbstractScanner {
        private ListFilter() {
        }

        public List<File> scan(Iterable<File> newfiles, File root) {
            this.setupDefaultFilters();
            ArrayList<File> includedFiles = new ArrayList<File>();
            int rootPathLength = root.getAbsolutePath().length();
            for (File file : newfiles) {
                String name = file.getAbsolutePath().substring(rootPathLength + 1);
                if (!file.isFile() || !this.isIncluded(name) || this.isExcluded(name)) continue;
                includedFiles.add(file);
            }
            return includedFiles;
        }

        public void scan() {
            throw new UnsupportedOperationException();
        }

        public String[] getIncludedFiles() {
            throw new UnsupportedOperationException();
        }

        public String[] getIncludedDirectories() {
            throw new UnsupportedOperationException();
        }

        public File getBasedir() {
            throw new UnsupportedOperationException();
        }
    }
}

