/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.maven.filter;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.filter.MavenResolutionFilter;

public class ScopeFilter
implements MavenResolutionFilter {
    private final Set<ScopeType> allowedScopes = EnumSet.noneOf(ScopeType.class);

    public ScopeFilter() {
        this(ScopeType.COMPILE);
    }

    public ScopeFilter(ScopeType ... scopes) {
        if (scopes.length == 0) {
            this.allowedScopes.add(ScopeType.COMPILE);
        } else {
            this.allowedScopes.addAll(Arrays.asList(scopes));
        }
    }

    @Override
    public boolean accepts(MavenDependency dependency, List<MavenDependency> dependenciesForResolution, List<MavenDependency> dependencyAncestors) {
        if (dependency == null) {
            return false;
        }
        return this.allowedScopes.contains((Object)dependency.getScope());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ScopeFilter [");
        for (ScopeType st : this.allowedScopes) {
            sb.append((Object)st).append(", ");
        }
        if (sb.indexOf(", ") != -1) {
            sb.delete(sb.lastIndexOf(", "), sb.length());
        }
        sb.append("]");
        return sb.toString();
    }
}

