/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.maven;

import java.util.concurrent.ConcurrentHashMap;

public class PackagingType {
    private static final ConcurrentHashMap<String, PackagingType> cache = new ConcurrentHashMap();
    public static final PackagingType POM = new PackagingType("pom");
    public static final PackagingType JAR = new PackagingType("jar");
    public static final PackagingType TEST_JAR = new PackagingType("test-jar", "jar", "tests");
    public static final PackagingType MAVEN_PLUGIN = new PackagingType("maven-plugin", "jar", "");
    public static final PackagingType EJB_CLIENT = new PackagingType("ejb-client", "jar", "client");
    public static final PackagingType EJB = new PackagingType("ejb", "jar", "");
    public static final PackagingType WAR = new PackagingType("war");
    public static final PackagingType EAR = new PackagingType("ear");
    public static final PackagingType RAR = new PackagingType("rar");
    public static final PackagingType PAR = new PackagingType("par");
    public static final PackagingType JAVADOC = new PackagingType("javadoc", "jar", "javadoc");
    public static final PackagingType JAVA_SOURCE = new PackagingType("java-source", "jar", "sources");
    private final String id;
    private final String extension;
    private final String classifier;

    private PackagingType(String id, String extension, String classifier) {
        this.id = id;
        this.extension = extension;
        this.classifier = classifier;
        cache.putIfAbsent(id, this);
    }

    private PackagingType(String id) {
        this(id, id, "");
    }

    public String getId() {
        return this.id;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String toString() {
        return this.id;
    }

    public static PackagingType of(String typeName) throws IllegalArgumentException {
        if (typeName == null || typeName.length() == 0) {
            throw new IllegalArgumentException("Packaging type must not be null nor empty.");
        }
        return cache.putIfAbsent(typeName, new PackagingType(typeName));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PackagingType other = (PackagingType)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

