/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.aphrodite.repository.services.gitlab;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.Branch;
import org.gitlab4j.api.models.Label;
import org.gitlab4j.api.models.Member;
import org.gitlab4j.api.models.MergeRequest;
import org.gitlab4j.api.models.MergeRequestFilter;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.User;
import org.jboss.set.aphrodite.common.Utils;
import org.jboss.set.aphrodite.config.RepositoryConfig;
import org.jboss.set.aphrodite.domain.Codebase;
import org.jboss.set.aphrodite.domain.Commit;
import org.jboss.set.aphrodite.domain.CommitStatus;
import org.jboss.set.aphrodite.domain.Issue;
import org.jboss.set.aphrodite.domain.PullRequest;
import org.jboss.set.aphrodite.domain.PullRequestState;
import org.jboss.set.aphrodite.domain.RateLimit;
import org.jboss.set.aphrodite.domain.Repository;
import org.jboss.set.aphrodite.domain.spi.PullRequestHome;
import org.jboss.set.aphrodite.repository.services.common.AbstractRepositoryService;
import org.jboss.set.aphrodite.repository.services.common.RepositoryType;
import org.jboss.set.aphrodite.repository.services.gitlab.GitLabPullRequestHomeService;
import org.jboss.set.aphrodite.repository.services.gitlab.GitLabUtils;
import org.jboss.set.aphrodite.spi.NotFoundException;
import org.jboss.set.aphrodite.spi.RepositoryService;

public class GitLabRepositoryService
extends AbstractRepositoryService
implements RepositoryService {
    private static final Log LOG = LogFactory.getLog(GitLabRepositoryService.class);
    private GitLabApi gitLabApi;
    private GitLabPullRequestHomeService prHome;

    public GitLabRepositoryService() {
        super(RepositoryType.GITLAB);
    }

    public boolean init(RepositoryConfig config) {
        boolean result = super.init(config);
        LOG.debug((Object)("Initializing GitLab repository " + config.getUrl()));
        if (result) {
            try {
                this.gitLabApi = new GitLabApi(config.getUrl(), config.getPassword());
                User user = this.gitLabApi.getUserApi().getCurrentUser();
                if (user.getUsername().equalsIgnoreCase(config.getUsername())) {
                    this.prHome = new GitLabPullRequestHomeService(this.gitLabApi, this);
                    result = true;
                } else {
                    LOG.warn((Object)("Username is different to the configuration one " + user.getName()));
                    result = false;
                }
            }
            catch (GitLabApiException e) {
                LOG.warn((Object)("Error initializing gitlab " + config.getUrl()), (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    protected Log getLog() {
        return LOG;
    }

    private Repository getRepository(String repoId) throws NotFoundException {
        try {
            List branches = this.gitLabApi.getRepositoryApi().getBranches((Object)repoId);
            Repository repo = new Repository(new URL(this.baseUrl + repoId));
            ArrayList<Codebase> branchNames = new ArrayList<Codebase>(branches.size());
            for (Branch b : branches) {
                branchNames.add(new Codebase(b.getName()));
            }
            repo.getCodebases().addAll(branchNames);
            return repo;
        }
        catch (MalformedURLException | GitLabApiException e) {
            throw new NotFoundException(e);
        }
    }

    public Repository getRepository(URL url) throws NotFoundException {
        GitLabUtils.checkIsInRepo(url, this.baseUrl);
        String repoId = GitLabUtils.getProjectIdFromURL(url);
        if (repoId == null) {
            throw new NotFoundException("Repository " + url + " cannot be found.");
        }
        return this.getRepository(repoId);
    }

    public PullRequest getPullRequest(URL url) throws NotFoundException {
        GitLabUtils.checkIsInRepo(url, this.baseUrl);
        String[] res = GitLabUtils.getProjectIdAndLastFieldFromURL(url);
        if (res != null && res.length == 2) {
            try {
                String repoId = res[0];
                int mergeId = Integer.parseInt(res[1]);
                Repository repo = this.getRepository(repoId);
                MergeRequest merge = this.gitLabApi.getMergeRequestApi().getMergeRequest((Object)repoId, Integer.valueOf(mergeId));
                List commits = this.gitLabApi.getMergeRequestApi().getCommits((Object)repoId, mergeId);
                return GitLabUtils.toPullRequest(merge, commits, url, repo, this.prHome);
            }
            catch (GitLabApiException e) {
                throw new NotFoundException((Throwable)e);
            }
        }
        throw new NotFoundException("Merge Request " + url + " cannot be found.");
    }

    public List<PullRequest> getPullRequestsByState(Repository repository, PullRequestState state) throws NotFoundException {
        String repoId = GitLabUtils.getProjectIdFromURL(repository.getURL());
        try {
            Project project = this.gitLabApi.getProjectApi().getProject((Object)repoId);
            MergeRequestFilter filter = new MergeRequestFilter();
            filter.setState(Constants.MergeRequestState.OPENED);
            filter.setProjectId(project.getId());
            List merges = this.gitLabApi.getMergeRequestApi().getMergeRequests(filter);
            ArrayList<PullRequest> prs = new ArrayList<PullRequest>(merges.size());
            for (MergeRequest merge : merges) {
                List commits = this.gitLabApi.getMergeRequestApi().getCommits((Object)repoId, merge.getIid().intValue());
                prs.add(GitLabUtils.toPullRequest(merge, commits, new URL(repository.getURL() + "/merge_requests/" + merge.getIid()), repository, this.prHome));
            }
            return prs;
        }
        catch (MalformedURLException | GitLabApiException e) {
            throw new NotFoundException(e);
        }
    }

    @Deprecated
    public List<PullRequest> findPullRequestsRelatedTo(PullRequest pullRequest) {
        return this.prHome.findReferencedPullRequests(pullRequest);
    }

    @Deprecated
    public List<PullRequest> getPullRequestsAssociatedWith(Issue issue) throws NotFoundException {
        Utils.logException((Log)LOG, (Exception)new UnsupportedOperationException("Not yet implemented."));
        return Collections.emptyList();
    }

    @Deprecated
    public void addCommentToPullRequest(PullRequest pullRequest, String comment) throws NotFoundException {
        this.prHome.addComment(pullRequest, comment);
    }

    public boolean hasModifiableLabels(Repository repository) throws NotFoundException {
        String repoId = GitLabUtils.getProjectIdFromURL(repository.getURL());
        try {
            User user = this.gitLabApi.getUserApi().getCurrentUser();
            Member member = this.gitLabApi.getProjectApi().getMember((Object)repoId, user.getId());
            return member.getAccessLevel().ordinal() >= AccessLevel.DEVELOPER.ordinal();
        }
        catch (GitLabApiException e) {
            LOG.info((Object)"hasModifiableLabels error", (Throwable)e);
            return false;
        }
    }

    public List<org.jboss.set.aphrodite.domain.Label> getLabelsFromRepository(Repository repository) throws NotFoundException {
        String repoId = GitLabUtils.getProjectIdFromURL(repository.getURL());
        try {
            List labels = this.gitLabApi.getLabelsApi().getProjectLabels((Object)repoId);
            ArrayList<org.jboss.set.aphrodite.domain.Label> res = new ArrayList<org.jboss.set.aphrodite.domain.Label>(labels.size());
            for (Label l : labels) {
                res.add(GitLabUtils.toLabel(l, repository.getURL()));
            }
            return res;
        }
        catch (GitLabApiException e) {
            throw new NotFoundException((Throwable)e);
        }
    }

    @Deprecated
    public List<org.jboss.set.aphrodite.domain.Label> getLabelsFromPullRequest(PullRequest pullRequest) throws NotFoundException {
        return this.prHome.getLabels(pullRequest);
    }

    @Deprecated
    public void setLabelsToPullRequest(PullRequest pullRequest, List<org.jboss.set.aphrodite.domain.Label> labels) throws NotFoundException {
        this.prHome.setLabels(pullRequest, labels);
    }

    @Deprecated
    public void addLabelToPullRequest(PullRequest pullRequest, String labelName) throws NotFoundException {
        this.prHome.addLabel(pullRequest, new org.jboss.set.aphrodite.domain.Label(labelName));
    }

    @Deprecated
    public void removeLabelFromPullRequest(PullRequest pullRequest, String labelName) throws NotFoundException {
        this.prHome.removeLabel(pullRequest, new org.jboss.set.aphrodite.domain.Label(labelName));
    }

    @Deprecated
    public CommitStatus getCommitStatusFromPullRequest(PullRequest pullRequest) throws NotFoundException {
        return this.prHome.getCommitStatus(pullRequest);
    }

    public boolean repositoryAccessable(URL url) {
        try {
            String repoId = GitLabUtils.getProjectIdFromURL(url);
            boolean res = GitLabUtils.urlIsInRepo(url, this.baseUrl) && this.gitLabApi.getRepositoryApi().getBranches((Object)repoId) != null;
            return res;
        }
        catch (GitLabApiException e) {
            LOG.info((Object)("Invalid repo url " + url), (Throwable)e);
            return false;
        }
    }

    public List<Commit> getCommitsSince(URL url, String branch, long since) {
        try {
            String repoId = GitLabUtils.getProjectIdFromURL(url);
            List glCommits = this.gitLabApi.getCommitsApi().getCommits((Object)repoId, branch, new Date(since), new Date());
            ArrayList<Commit> commits = new ArrayList<Commit>();
            for (org.gitlab4j.api.models.Commit c : glCommits) {
                commits.add(new Commit(c.getId(), c.getTitle()));
            }
            return commits;
        }
        catch (GitLabApiException glae) {
            return Collections.EMPTY_LIST;
        }
    }

    public RateLimit getRateLimit() throws NotFoundException {
        return null;
    }

    public RepositoryType getRepositoryType() {
        return this.REPOSITORY_TYPE;
    }

    public PullRequestHome getPullRequestHome() {
        return this.prHome;
    }
}

