/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.jaas;

import java.io.IOException;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Named;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.seam.security.Authenticator;
import org.jboss.seam.security.BaseAuthenticator;
import org.jboss.seam.security.Credentials;
import org.jboss.seam.security.Identity;
import org.jboss.solder.logging.Logger;
import org.picketlink.idm.api.User;
import org.picketlink.idm.impl.api.PasswordCredential;
import org.picketlink.idm.impl.api.model.SimpleUser;

@Named
@RequestScoped
public class JaasAuthenticator
extends BaseAuthenticator
implements Authenticator {
    private static final Logger log = Logger.getLogger(JaasAuthenticator.class);
    @Inject
    Identity identity;
    @Inject
    Credentials credentials;
    @Inject
    BeanManager manager;
    private Subject subject = new Subject();
    private String jaasConfigName = null;

    public void authenticate() {
        if (this.getJaasConfigName() == null) {
            throw new IllegalStateException("jaasConfigName cannot be null.  Please set it to a valid JAAS configuration name.");
        }
        try {
            this.getLoginContext().login();
            this.setStatus(Authenticator.AuthenticationStatus.SUCCESS);
            this.setUser((User)new SimpleUser(this.credentials.getUsername()));
        }
        catch (LoginException e) {
            this.setStatus(Authenticator.AuthenticationStatus.FAILURE);
            log.error((Object)"JAAS authentication failed", (Throwable)e);
        }
    }

    protected LoginContext getLoginContext() throws LoginException {
        return new LoginContext(this.getJaasConfigName(), this.subject, this.createCallbackHandler());
    }

    public CallbackHandler createCallbackHandler() {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName(JaasAuthenticator.this.credentials.getUsername());
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        if (!(JaasAuthenticator.this.credentials.getCredential() instanceof PasswordCredential)) continue;
                        PasswordCredential credential = (PasswordCredential)JaasAuthenticator.this.credentials.getCredential();
                        ((PasswordCallback)callbacks[i]).setPassword(credential.getValue() != null ? credential.getValue().toCharArray() : null);
                        continue;
                    }
                    log.warn((Object)("Unsupported callback " + callbacks[i]));
                }
            }
        };
    }

    public String getJaasConfigName() {
        return this.jaasConfigName;
    }

    public void setJaasConfigName(String jaasConfigName) {
        this.jaasConfigName = jaasConfigName;
    }

    @Override
    public void postAuthenticate() {
    }
}

