/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.transaction;

import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jboss.seam.faces.transaction.SeamManagedTransaction;
import org.jboss.seam.faces.transaction.SeamManagedTransactionType;
import org.jboss.seam.faces.view.config.ViewConfigStore;
import org.jboss.seam.persistence.PersistenceContexts;
import org.jboss.seam.solder.core.Requires;
import org.jboss.seam.transaction.DefaultTransaction;
import org.jboss.seam.transaction.SeamTransaction;

@Requires(value={"org.jboss.seam.persistence.PersistenceContextsImpl", "org.jboss.seam.transaction.TransactionExtension"})
public class TransactionPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = -9127555729455066493L;
    private final transient Logger log = Logger.getLogger(TransactionPhaseListener.class);
    @Inject
    private ViewConfigStore dataStore;
    @Inject
    @DefaultTransaction
    private SeamTransaction transaction;
    @Inject
    private PersistenceContexts persistenceContexts;

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        this.log.trace((Object)("before phase: " + event.getPhaseId()));
        this.handleTransactionsBeforePhase(event);
    }

    public void afterPhase(PhaseEvent event) {
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.persistenceContexts.afterRender();
        }
        this.handleTransactionsAfterPhase(event);
    }

    public void handleTransactionsBeforePhase(PhaseEvent event) {
        PhaseId phaseId = event.getPhaseId();
        if (this.seamManagedTransactionStatus(phaseId)) {
            boolean beginTran;
            if (phaseId == PhaseId.RENDER_RESPONSE) {
                this.persistenceContexts.beforeRender();
            }
            boolean bl = beginTran = phaseId == PhaseId.RENDER_RESPONSE || phaseId == PhaseId.RESTORE_VIEW;
            if (beginTran) {
                this.begin(phaseId);
            }
        }
    }

    public void handleTransactionsAfterPhase(PhaseEvent event) {
        PhaseId phaseId = event.getPhaseId();
        if (this.seamManagedTransactionStatus(phaseId)) {
            boolean commitTran;
            boolean bl = commitTran = phaseId == PhaseId.INVOKE_APPLICATION || event.getFacesContext().getRenderResponse() || event.getFacesContext().getResponseComplete() || phaseId == PhaseId.RENDER_RESPONSE;
            if (commitTran) {
                this.commitOrRollback(phaseId);
            }
        }
    }

    void begin(PhaseId phaseId) {
        this.begin("prior to phase: " + phaseId);
    }

    void begin(String phaseString) {
        try {
            if (!this.transaction.isActiveOrMarkedRollback()) {
                this.log.debug((Object)("beginning transaction " + phaseString));
                this.transaction.begin();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not start transaction", e);
        }
    }

    void commitOrRollback(PhaseId phaseId) {
        this.commitOrRollback("after phase: " + phaseId);
    }

    void commitOrRollback(String phaseString) {
        try {
            if (this.transaction.isActive()) {
                try {
                    this.log.debug((Object)("committing transaction " + phaseString));
                    this.transaction.commit();
                }
                catch (IllegalStateException e) {
                    this.log.warn((Object)"TX commit failed with illegal state exception. This may be because the tx timed out and was rolled back in the background.", (Throwable)e);
                }
            } else if (this.transaction.isRolledBackOrMarkedRollback()) {
                this.log.debug((Object)("rolling back transaction " + phaseString));
                this.transaction.rollback();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not commit transaction", e);
        }
    }

    private boolean seamManagedTransactionStatus(PhaseId phase) {
        SeamManagedTransactionType config;
        SeamManagedTransaction an = null;
        if (FacesContext.getCurrentInstance() != null && FacesContext.getCurrentInstance().getViewRoot() != null) {
            an = this.dataStore.getAnnotationData(FacesContext.getCurrentInstance().getViewRoot().getViewId(), SeamManagedTransaction.class);
        }
        if ((config = an == null ? SeamManagedTransactionType.ENABLED : an.value()) == SeamManagedTransactionType.DISABLED) {
            return false;
        }
        return config != SeamManagedTransactionType.RENDER_RESPONSE || phase == PhaseId.RENDER_RESPONSE;
    }
}

