/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.rewrite;

import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.servlet.WebXmlParser;
import com.ocpsoft.pretty.faces.spi.ConfigurationProvider;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import org.jboss.seam.faces.rewrite.UrlMapping;
import org.jboss.seam.faces.util.BeanManagerUtils;
import org.jboss.seam.faces.view.config.ViewConfigStore;
import org.jboss.seam.solder.core.Requires;
import org.xml.sax.SAXException;

@Requires(value={"com.ocpsoft.pretty.faces.spi.ConfigurationProvider"})
public class RewriteConfiguration
implements ConfigurationProvider {
    public static final String PRETTYFACES_CONFIG_SERVLETCONTEXT_KEY = "org.jboss.seam.faces.com.ocpsoft.pretty.faces.spi.ConfigurationProvider";

    public PrettyConfig loadConfiguration(ServletContext sc) {
        WebXmlParser webXmlParser = new WebXmlParser();
        try {
            webXmlParser.parse(sc);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
        BeanManager beanManager = (BeanManager)sc.getAttribute("org.jboss.seam.faces.javax.enterprise.spi.BeanManager");
        ViewConfigStore store = BeanManagerUtils.getContextualInstance(beanManager, ViewConfigStore.class);
        List<com.ocpsoft.pretty.faces.config.mapping.UrlMapping> mappings = this.loadUrlMappings(store, webXmlParser.getFacesMapping());
        PrettyConfig prettyConfig = new PrettyConfig();
        prettyConfig.setMappings(mappings);
        return prettyConfig;
    }

    private List<com.ocpsoft.pretty.faces.config.mapping.UrlMapping> loadUrlMappings(ViewConfigStore store, String facesMapping) {
        ArrayList<com.ocpsoft.pretty.faces.config.mapping.UrlMapping> mappings = new ArrayList<com.ocpsoft.pretty.faces.config.mapping.UrlMapping>();
        Map<String, Annotation> map = store.getAllAnnotationViewMap(UrlMapping.class);
        if (map != null) {
            for (Map.Entry<String, Annotation> entry : map.entrySet()) {
                mappings.add(this.buildPrettyFacesUrlMapping(entry.getKey(), entry.getValue(), facesMapping));
            }
        }
        return mappings;
    }

    private com.ocpsoft.pretty.faces.config.mapping.UrlMapping buildPrettyFacesUrlMapping(String viewId, Annotation annotation, String facesMapping) {
        UrlMapping urlMappingAnnotation = (UrlMapping)annotation;
        com.ocpsoft.pretty.faces.config.mapping.UrlMapping urlMapping = new com.ocpsoft.pretty.faces.config.mapping.UrlMapping();
        urlMapping.setViewId(this.buildViewUrl(viewId, facesMapping));
        urlMapping.setId(viewId);
        urlMapping.setOnPostback(urlMappingAnnotation.onPostback());
        urlMapping.setOutbound(urlMappingAnnotation.outbound());
        urlMapping.setPattern(urlMappingAnnotation.pattern());
        return urlMapping;
    }

    String buildViewUrl(String viewId, String facesMapping) {
        String viewUrl = null;
        if (facesMapping.endsWith("*")) {
            viewUrl = facesMapping.replaceFirst("\\*", viewId);
        } else if (facesMapping.startsWith("*")) {
            String[] splits = viewId.split("\\.");
            String viewName = splits.length == 1 ? viewId : splits[0];
            viewUrl = facesMapping.replaceFirst("\\*", viewName);
        }
        if (!viewUrl.startsWith("/")) {
            viewUrl = "/" + viewUrl;
        }
        return viewUrl;
    }
}

