/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.hibernate;

import java.util.HashSet;
import java.util.Set;

import org.jboss.classloading.spi.visitor.ClassVisitor;
import org.jboss.classloading.spi.visitor.ResourceContext;

/**
 * Hibernate's classes visitor.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class ClassesVisitor extends ClassVisitor
{
   private Set<String> strings;

   public ClassesVisitor()
   {
      this(null);
   }

   public ClassesVisitor(Set<String> strings)
   {
      if (strings == null)
         strings = new HashSet<String>();
      this.strings = strings;
   }

   public void visit(ResourceContext resource)
   {
      strings.add(resource.getClassName());
   }

   public Set<String> getStrings()
   {
      return strings;
   }
}