/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve;

import Acme.Serve.Serve;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class SSLAcceptor
implements Serve.Acceptor {
    public static final String ARG_ALGORITHM = "algorithm";
    public static final String ARG_CLIENTAUTH = "clientAuth";
    public static final String ARG_KEYSTOREFILE = "keystoreFile";
    public static final String ARG_KEYSTOREPASS = "keystorePass";
    public static final String ARG_KEYSTORETYPE = "keystoreType";
    public static final String ARG_KEYPASS = "keyPass";
    public static final String ARG_PROTOCOL = "protocol";
    public static final String ARG_BACKLOG = "backlog";
    public static final String ARG_IFADDRESS = "ifAddress";
    public static final String ARG_PORT = "ssl-port";
    public static final String PROTOCOL_HANDLER = "com.sun.net.ssl.internal.www.protocol";
    public static final String PROTOCOL_PACKAGES = "java.protocol.handler.pkgs";
    public static final String SUNX509 = "SunX509";
    public static final int PORT = 8443;
    public static final int BACKLOG = 1000;
    public static final String KEYSTORETYPE = "JKS";
    public static final String TLS = "TLS";
    public static final String protocol = "TLS";
    private static final String KEYSTOREPASS = "123456";
    protected String keystoreFile = System.getProperty("user.home") + File.separator + ".keystore";
    protected ServerSocket socket;

    private String getKeystoreFile() {
        return this.keystoreFile;
    }

    @Override
    public Socket accept() throws IOException {
        Socket result = this.socket.accept();
        if (result != null) {
            result.setSoTimeout(300000);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws IOException {
        try {
            this.socket.close();
        }
        finally {
            this.socket = null;
        }
    }

    @Override
    public void init(Map inProperties, Map outProperties) throws IOException {
        SSLServerSocketFactory sslSoc = null;
        KeyStore keyStore = null;
        FileInputStream istream = null;
        String keystorePass = null;
        try {
            String keystoreType = this.getWithDefault(inProperties, ARG_KEYSTORETYPE, KEYSTORETYPE);
            keyStore = KeyStore.getInstance(keystoreType);
            String keystoreFile = (String)inProperties.get(ARG_KEYSTOREFILE);
            if (keystoreFile == null) {
                keystoreFile = this.getKeystoreFile();
            }
            istream = new FileInputStream(keystoreFile);
            keystorePass = this.getWithDefault(inProperties, ARG_KEYSTOREPASS, KEYSTOREPASS);
            keyStore.load(istream, keystorePass.toCharArray());
        }
        catch (Exception e) {
            System.err.println("initKeyStore:  " + e);
            e.printStackTrace();
            throw new IOException(e.toString());
        }
        finally {
            if (istream != null) {
                istream.close();
            }
        }
        try {
            try {
                Security.addProvider((Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance());
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new IOException(t.toString());
            }
            String protocol = this.getWithDefault(inProperties, ARG_PROTOCOL, "TLS");
            SSLContext context = SSLContext.getInstance(protocol);
            String algorithm = this.getWithDefault(inProperties, ARG_ALGORITHM, SUNX509);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
            String keyPass = this.getWithDefault(inProperties, ARG_KEYPASS, keystorePass);
            keyManagerFactory.init(keyStore, keyPass.toCharArray());
            context.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
            sslSoc = context.getServerSocketFactory();
        }
        catch (Exception e) {
            System.err.println("SSLsocket creation:  " + e);
            e.printStackTrace();
            throw new IOException(e.toString());
        }
        int port = 8443;
        if (inProperties.get(ARG_PORT) != null) {
            try {
                port = Integer.parseInt((String)inProperties.get(ARG_PORT));
            }
            catch (NumberFormatException nfe) {}
        } else if (inProperties.get("port") != null) {
            port = (Integer)inProperties.get("port");
        }
        this.socket = inProperties.get(ARG_BACKLOG) == null ? (inProperties.get(ARG_IFADDRESS) == null ? sslSoc.createServerSocket(port) : sslSoc.createServerSocket(port, 1000, InetAddress.getByName((String)inProperties.get(ARG_IFADDRESS)))) : (inProperties.get(ARG_IFADDRESS) == null ? sslSoc.createServerSocket(port, new Integer((String)inProperties.get(ARG_BACKLOG))) : sslSoc.createServerSocket(port, new Integer((String)inProperties.get(ARG_BACKLOG)), InetAddress.getByName((String)inProperties.get(ARG_IFADDRESS))));
        this.initServerSocket(this.socket, "true".equals(inProperties.get(ARG_CLIENTAUTH)));
        if (outProperties != null) {
            outProperties.put("bind-address", this.socket.getInetAddress().getHostName());
        }
    }

    protected static void initHandler() {
        String packages = System.getProperty(PROTOCOL_PACKAGES);
        if (packages == null) {
            packages = PROTOCOL_HANDLER;
        } else if (packages.indexOf(PROTOCOL_HANDLER) < 0) {
            packages = packages + "|com.sun.net.ssl.internal.www.protocol";
        }
        System.setProperty(PROTOCOL_PACKAGES, packages);
    }

    public String toString() {
        return this.socket != null ? this.socket.toString() : "SSLAcceptor uninitialized";
    }

    protected void initServerSocket(ServerSocket ssocket, boolean clientAuth) {
        SSLServerSocket socket = (SSLServerSocket)ssocket;
        String[] cipherSuites = socket.getSupportedCipherSuites();
        socket.setEnabledCipherSuites(cipherSuites);
        socket.setNeedClientAuth(clientAuth);
    }

    private String getWithDefault(Map args, String name, String defValue) {
        String result = (String)args.get(name);
        if (result == null) {
            return defValue;
        }
        return result;
    }

    static {
        SSLAcceptor.initHandler();
    }
}

