/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.idm.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.jboss.resteasy.skeleton.key.SkeletonKeyContextResolver;
import org.jboss.resteasy.skeleton.key.idm.adapters.infinispan.InfinispanIDM;
import org.jboss.resteasy.skeleton.key.idm.service.RealmFactory;
import org.jboss.resteasy.skeleton.key.idm.service.RealmResource;
import org.jboss.resteasy.skeleton.key.idm.service.TokenManagement;

@ApplicationPath(value="/")
public class SkeletonKeyApplication
extends Application {
    protected Set<Object> singletons = new HashSet<Object>();
    protected Set<Class<?>> classes = new HashSet();

    public SkeletonKeyApplication() {
        Cache cache = this.getCache();
        InfinispanIDM idm = new InfinispanIDM(cache);
        this.singletons.add(new TokenManagement(idm));
        this.singletons.add(new RealmFactory(idm));
        this.singletons.add(new RealmResource(idm));
        this.classes.add(SkeletonKeyContextResolver.class);
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    protected Cache getCache() {
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("skeleton-key.xml");
            return new DefaultCacheManager(is).getCache("skeleton-key");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

